/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.mohistmc.MohistMCStart;
import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.util.JarTool;
import com.mohistmc.util.MD5Util;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import mjson.Json;

public class UpdateUtils {
    public static void versionCheck() {
        System.out.println(MohistMCStart.i18n.get("update.check"));
        System.out.println(MohistMCStart.i18n.get("update.stopcheck"));
        try {
            Json json = Json.read(new URL("https://mohistmc.com/api/1.20.1/latest"));
            String jar_sha = MohistMCStart.getVersion();
            String build_number = "1.20.1-" + json.at("number").asInteger();
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(json.at("timeinmillis").asLong()));
            if (jar_sha.equals(build_number)) {
                System.out.println(MohistMCStart.i18n.get("update.latest", jar_sha, build_number));
            } else {
                System.out.println(MohistMCStart.i18n.get("update.detect", build_number, jar_sha, time));
                if (MohistConfigUtil.CHECK_UPDATE_AUTO_DOWNLOAD()) {
                    UpdateUtils.downloadFile(json.at("url").asString(), JarTool.getFile());
                    UpdateUtils.restartServer(new ArrayList<String>(Arrays.asList("java", "-jar", JarTool.getJarName())), true);
                }
            }
        }
        catch (Throwable e) {
            System.out.println(MohistMCStart.i18n.get("check.update.noci"));
        }
    }

    public static void downloadFile(String URL2, File f) throws Exception {
        UpdateUtils.downloadFile(URL2, f, null, true);
    }

    public static void downloadFile(String URL2, File f, String md5, boolean showlog) throws Exception {
        URLConnection conn = UpdateUtils.getConn(URL2);
        if (showlog) {
            System.out.println(MohistMCStart.i18n.get("download.file", f.getName(), UpdateUtils.getSize(conn.getContentLength())));
        }
        ReadableByteChannel rbc = Channels.newChannel(conn.getInputStream());
        FileChannel fc = FileChannel.open(f.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        fc.transferFrom(rbc, 0L, Long.MAX_VALUE);
        fc.close();
        rbc.close();
        String MD5 = MD5Util.getMd5(f);
        if (f.getName().endsWith(".jar") && md5 != null && MD5 != null && !MD5.equals(md5.toLowerCase())) {
            f.delete();
            System.out.println(MohistMCStart.i18n.get("file.download.nook.md5", URL2, MD5, md5.toLowerCase()));
            return;
        }
        if (showlog) {
            System.out.println(MohistMCStart.i18n.get("download.file.ok", f.getName()));
        }
    }

    public static String getSize(long size) {
        return size >= 0x100000L ? (float)size / 1048576.0f + "MB" : (size >= 1024L ? (float)size / 1024.0f + " KB" : size + " B");
    }

    public static void restartServer(ArrayList<String> cmd, boolean shutdown) throws Exception {
        System.out.println(MohistMCStart.i18n.get("jarfile.restart"));
        if (cmd.stream().anyMatch(s -> s.contains("-Xms"))) {
            System.out.println(MohistMCStart.i18n.get("xmswarn"));
        }
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.directory(JarTool.getJarDir());
        pb.inheritIO().start().waitFor();
        Thread.sleep(2000L);
        if (shutdown) {
            System.exit(0);
        }
    }

    public static URLConnection getConn(String URL2) {
        URLConnection conn = null;
        try {
            conn = new URL(URL2).openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:31.0) Gecko/20100101 Firefox/31.0");
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
        return conn;
    }
}

