/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.libraries;

import com.mohistmc.libraries.DownloadSource;
import com.mohistmc.libraries.Libraries;
import com.mohistmc.tools.ConnectionUtil;
import com.mohistmc.tools.MD5Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;

public class LibrariesDownloadQueue {
    private final Set<Libraries> fail = new HashSet<Libraries>();
    public final Set<Libraries> allLibraries = new HashSet<Libraries>();
    public InputStream inputStream = null;
    public Set<Libraries> need_download = new LinkedHashSet<Libraries>();
    public Set<Libraries> installer = new LinkedHashSet<Libraries>();
    public DownloadSource downloadSource = null;
    public int threadPoolSize = Runtime.getRuntime().availableProcessors();
    public String parentDirectory = "libraries";
    public String systemProperty = null;

    public static LibrariesDownloadQueue create() {
        return new LibrariesDownloadQueue();
    }

    public LibrariesDownloadQueue inputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public LibrariesDownloadQueue parentDirectory(String parentDirectory) {
        this.parentDirectory = parentDirectory;
        return this;
    }

    public LibrariesDownloadQueue downloadSource(String downloadSource) {
        block2: {
            try {
                this.downloadSource = DownloadSource.valueOf(downloadSource);
            }
            catch (Exception e) {
                if (!ConnectionUtil.isValid(downloadSource) || !ConnectionUtil.canAccess(downloadSource)) break block2;
                this.systemProperty = downloadSource;
            }
        }
        return this;
    }

    public LibrariesDownloadQueue threadPoolSize(int threadPoolSize) {
        this.threadPoolSize = Math.max(1, Math.min(Runtime.getRuntime().availableProcessors(), threadPoolSize));
        return this;
    }

    public LibrariesDownloadQueue build() {
        if (this.downloadSource == null) {
            this.downloadSource = DownloadSource.fast();
        }
        this.init();
        return this;
    }

    public void progressBar() {
        if (this.needDownload()) {
            ConcurrentLinkedQueue<Libraries> queue = new ConcurrentLinkedQueue<Libraries>(this.need_download);
            ProgressBarBuilder builder = new ProgressBarBuilder().setTaskName("").setStyle(ProgressBarStyle.ASCII).setUpdateIntervalMillis(100).setInitialMax(this.need_download.size());
            try (ProgressBar pb = builder.build();){
                ExecutorService executor = Executors.newFixedThreadPool(this.threadPoolSize);
                ArrayList futures = new ArrayList();
                AtomicInteger downloadedCount = new AtomicInteger(0);
                while (!queue.isEmpty()) {
                    Libraries lib = (Libraries)queue.poll();
                    if (lib == null) continue;
                    Runnable runnable = this.getRunnable(lib, pb, downloadedCount);
                    Future<?> future = executor.submit(runnable);
                    futures.add(future);
                }
                for (Future future : futures) {
                    if (future == null) continue;
                    future.get();
                }
                executor.shutdown();
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!this.fail.isEmpty()) {
            this.progressBar();
        }
    }

    public boolean needDownload() {
        for (Libraries libraries : this.allLibraries) {
            File lib = new File(this.parentDirectory, libraries.path);
            if (lib.exists() && Objects.equals(MD5Util.get(lib), libraries.md5)) continue;
            this.need_download.add(libraries);
        }
        return !this.need_download.isEmpty();
    }

    private Runnable getRunnable(Libraries lib, ProgressBar pb, AtomicInteger downloadedCount) {
        File file = new File(this.parentDirectory, lib.path);
        return () -> {
            try {
                file.getParentFile().mkdirs();
                String url = this.systemProperty != null ? this.systemProperty + lib.path : this.downloadSource.url + lib.path;
                ConnectionUtil.downloadFile(url, file);
                ProgressBar progressBar = pb;
                synchronized (progressBar) {
                    downloadedCount.addAndGet(1);
                    pb.step();
                }
                this.fail.remove(lib);
            }
            catch (Exception e) {
                if (!Objects.equals(MD5Util.get(file), lib.md5)) {
                    file.delete();
                }
                this.fail.add(lib);
            }
        };
    }

    private void init() {
        try {
            BufferedReader b = new BufferedReader(new InputStreamReader(this.inputStream));
            String line = b.readLine();
            while (line != null) {
                Libraries libraries = Libraries.from(line);
                this.allLibraries.add(libraries);
                if (libraries.isInstaller()) {
                    this.installer.add(libraries);
                }
                line = b.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "LibrariesDownloadQueue(downloadSource=" + this.downloadSource + ", threadPoolSize=" + this.threadPoolSize + ", parentDirectory=" + this.parentDirectory + ", systemProperty=" + this.systemProperty + ")";
    }
}

