/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.util;

import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.tools.OSUtil;
import com.mohistmc.util.JarLoader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import sun.misc.Unsafe;

public class MohistModuleManager {
    private static final MethodHandles.Lookup IMPL_LOOKUP;
    private static String MODULE_PATH;

    public MohistModuleManager(List<String> args) {
        this.applyLaunchArgs(args);
        MohistConfigUtil.INSTALLATIONFINISHED.setValues(false);
        MohistConfigUtil.save();
    }

    public static void addExports(String module, String pkg, String target) {
        if (target == null) {
            target = "ALL-UNNAMED";
        }
        try {
            MohistModuleManager.addExports(List.of(module + "/" + pkg + "=" + target));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void addExports(List<String> exports) throws Throwable {
        MethodHandle implAddExportsMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddExports", MethodType.methodType(Void.TYPE, String.class, Module.class));
        MethodHandle implAddExportsToAllUnnamedMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddExportsToAllUnnamed", MethodType.methodType(Void.TYPE, String.class));
        MohistModuleManager.addExtra(exports, implAddExportsMH, implAddExportsToAllUnnamedMH);
    }

    public static void addOpens(String module, String pkg, String target) {
        if (target == null) {
            target = "ALL-UNNAMED";
        }
        try {
            MohistModuleManager.addOpens(List.of(module + "/" + pkg + "=" + target));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void addOpens(List<String> opens) throws Throwable {
        MethodHandle implAddOpensMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddOpens", MethodType.methodType(Void.TYPE, String.class, Module.class));
        MethodHandle implAddOpensToAllUnnamedMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddOpensToAllUnnamed", MethodType.methodType(Void.TYPE, String.class));
        MohistModuleManager.addExtra(opens, implAddOpensMH, implAddOpensToAllUnnamedMH);
    }

    private static ParserData parseModuleExtra(String extra) {
        String[] all = extra.split("=", 2);
        if (all.length < 2) {
            return null;
        }
        String[] source = all[0].split("/", 2);
        if (source.length < 2) {
            return null;
        }
        return new ParserData(source[0], source[1], all[1]);
    }

    private static void addExtra(List<String> extras, MethodHandle implAddExtraMH, MethodHandle implAddExtraToAllUnnamedMH) {
        extras.forEach(extra -> {
            ParserData data = MohistModuleManager.parseModuleExtra(extra);
            if (data != null) {
                ModuleLayer.boot().findModule(data.module).ifPresent(m -> {
                    try {
                        if ("ALL-UNNAMED".equals(data.target)) {
                            implAddExtraToAllUnnamedMH.invokeWithArguments(m, data.packages);
                        } else {
                            ModuleLayer.boot().findModule(data.target).ifPresent(tm -> {
                                try {
                                    implAddExtraMH.invokeWithArguments(m, data.packages, tm);
                                }
                                catch (Throwable t) {
                                    throw new RuntimeException(t);
                                }
                            });
                        }
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                });
            }
        });
    }

    public void applyLaunchArgs(List<String> args) {
        ArrayList<String> opens = new ArrayList<String>();
        ArrayList<String> exports = new ArrayList<String>();
        args.parallelStream().forEach(arg -> {
            if (arg.startsWith("-p ")) {
                MODULE_PATH = arg.substring(2).trim();
            } else if (arg.startsWith("--add-opens")) {
                opens.add(arg.substring("--add-opens ".length()).trim());
            } else if (arg.startsWith("--add-exports")) {
                exports.add(arg.substring("--add-exports ".length()).trim());
            } else if (arg.startsWith("-D")) {
                String[] params = arg.substring(2).split("=", 2);
                System.setProperty(params[0], params[1]);
            }
        });
        try {
            this.loadModules(MODULE_PATH);
            Thread.sleep(500L);
            MohistModuleManager.addOpens(opens);
            MohistModuleManager.addExports(exports);
            Thread.sleep(500L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void loadModules(String modulePath) throws Throwable {
        ModuleFinder finder = ModuleFinder.of((Path[])Arrays.stream(modulePath.split(OSUtil.getOS() == OSUtil.OS.WINDOWS ? ";" : ":")).map(x$0 -> Paths.get(x$0, new String[0])).peek(JarLoader::loadJar).toArray(Path[]::new));
        MethodHandle loadModuleMH = IMPL_LOOKUP.findVirtual(Class.forName("jdk.internal.loader.BuiltinClassLoader"), "loadModule", MethodType.methodType(Void.TYPE, ModuleReference.class));
        Configuration config = Configuration.resolveAndBind(finder, List.of(ModuleLayer.boot().configuration()), finder, finder.findAll().stream().peek(mref -> {
            try {
                loadModuleMH.invokeWithArguments(Thread.currentThread().getContextClassLoader(), mref);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }).map(ModuleReference::descriptor).map(ModuleDescriptor::name).collect(Collectors.toList()));
        MethodHandle graphGetter = IMPL_LOOKUP.findGetter(Configuration.class, "graph", Map.class);
        HashMap<ResolvedModule, Set> graphMap = new HashMap<ResolvedModule, Set>((Map)graphGetter.invokeWithArguments(config));
        MethodHandle cfSetter = IMPL_LOOKUP.findSetter(ResolvedModule.class, "cf", Configuration.class);
        graphMap.forEach((k, v) -> {
            try {
                cfSetter.invokeWithArguments(k, ModuleLayer.boot().configuration());
                v.forEach(m -> {
                    try {
                        cfSetter.invokeWithArguments(m, ModuleLayer.boot().configuration());
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                });
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
        graphMap.putAll((Map)graphGetter.invokeWithArguments(ModuleLayer.boot().configuration()));
        IMPL_LOOKUP.findSetter(Configuration.class, "graph", Map.class).invokeWithArguments(ModuleLayer.boot().configuration(), new HashMap(graphMap));
        Set<ResolvedModule> oldBootModules = ModuleLayer.boot().configuration().modules();
        MethodHandle modulesSetter = IMPL_LOOKUP.findSetter(Configuration.class, "modules", Set.class);
        HashSet<ResolvedModule> modulesSet = new HashSet<ResolvedModule>(config.modules());
        modulesSetter.invokeWithArguments(ModuleLayer.boot().configuration(), new HashSet<ResolvedModule>(modulesSet));
        MethodHandle nameToModuleGetter = IMPL_LOOKUP.findGetter(Configuration.class, "nameToModule", Map.class);
        HashMap nameToModuleMap = new HashMap((Map)nameToModuleGetter.invokeWithArguments(ModuleLayer.boot().configuration()));
        nameToModuleMap.putAll((Map)nameToModuleGetter.invokeWithArguments(config));
        IMPL_LOOKUP.findSetter(Configuration.class, "nameToModule", Map.class).invokeWithArguments(ModuleLayer.boot().configuration(), new HashMap(nameToModuleMap));
        ((Map)IMPL_LOOKUP.findGetter(ModuleLayer.class, "nameToModule", Map.class).invokeWithArguments(ModuleLayer.boot())).putAll((Map)IMPL_LOOKUP.findStatic(Module.class, "defineModules", MethodType.methodType(Map.class, Configuration.class, Function.class, ModuleLayer.class)).invokeWithArguments(ModuleLayer.boot().configuration(), name -> Thread.currentThread().getContextClassLoader(), ModuleLayer.boot()));
        modulesSet.addAll(oldBootModules);
        modulesSetter.invokeWithArguments(ModuleLayer.boot().configuration(), new HashSet<ResolvedModule>(modulesSet));
        IMPL_LOOKUP.findSetter(ModuleLayer.class, "modules", Set.class).invokeWithArguments(ModuleLayer.boot(), null);
        IMPL_LOOKUP.findSetter(ModuleLayer.class, "servicesCatalog", Class.forName("jdk.internal.module.ServicesCatalog")).invokeWithArguments(ModuleLayer.boot(), null);
        MethodHandle implAddReadsMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddReads", MethodType.methodType(Void.TYPE, Module.class));
        config.modules().forEach(rm -> ModuleLayer.boot().findModule(rm.name()).ifPresent(m -> oldBootModules.forEach(brm -> ModuleLayer.boot().findModule(brm.name()).ifPresent(bm -> {
            try {
                implAddReadsMH.invokeWithArguments(m, bm);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }))));
    }

    static {
        MODULE_PATH = null;
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Unsafe unsafe = (Unsafe)theUnsafe.get(null);
            unsafe.ensureClassInitialized(MethodHandles.Lookup.class);
            Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            Object base = unsafe.staticFieldBase(field);
            long offset = unsafe.staticFieldOffset(field);
            IMPL_LOOKUP = (MethodHandles.Lookup)unsafe.getObject(base, offset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private record ParserData(String module, String packages, String target) {
    }
}

