/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.yml;

import com.mohistmc.yml.SmartString;
import com.mohistmc.yml.YamlReader;
import com.mohistmc.yml.YamlSection;
import com.mohistmc.yml.YamlWriter;
import com.mohistmc.yml.exceptions.DuplicateKeyException;
import com.mohistmc.yml.exceptions.IllegalKeyException;
import com.mohistmc.yml.exceptions.IllegalListException;
import com.mohistmc.yml.exceptions.NotLoadedException;
import com.mohistmc.yml.exceptions.YamlReaderException;
import com.mohistmc.yml.exceptions.YamlWriterException;
import com.mohistmc.yml.utils.UtilsFile;
import com.mohistmc.yml.utils.UtilsYaml;
import com.mohistmc.yml.utils.UtilsYamlSection;
import com.mohistmc.yml.watcher.DirWatcher;
import com.mohistmc.yml.watcher.FileEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public class Yaml {
    public static final Map<String, ReentrantLock> pathsAndLocks = new HashMap<String, ReentrantLock>();
    public static Charset charset = StandardCharsets.UTF_8;
    public final List<YamlSection> inEditModules = new ArrayList<YamlSection>();
    public final List<YamlSection> loadedModules = new ArrayList<YamlSection>();
    public final UtilsYaml utilsYaml = new UtilsYaml(this);
    public final UtilsYamlSection utilsYamlSection = new UtilsYamlSection();
    public final UtilsFile utilsFile = new UtilsFile();
    public File file;
    public InputStream inputStream;
    public OutputStream outputStream;
    public String inString;
    public String outString;
    public boolean isLoaded = false;
    public boolean isIgnoreNotLoadedException = false;
    public boolean isPostProcessingEnabled = true;
    public boolean isTrimLoadedValuesEnabled = true;
    public boolean isRemoveQuotesFromLoadedValuesEnabled = true;
    public boolean isRemoveLoadedNullValuesEnabled = true;
    public boolean isTrimCommentsEnabled = true;
    public boolean isReturnDefaultWhenValueIsNullEnabled = true;
    public boolean isWriteDefaultValuesWhenEmptyEnabled = true;
    public boolean isWriteDefaultCommentsWhenEmptyEnabled = true;
    public DirWatcher watcher = null;

    public Yaml(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, true);
    }

    public Yaml(InputStream inputStream, OutputStream outputStream, boolean isPostProcessingEnabled) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.init(isPostProcessingEnabled);
    }

    public Yaml(String inString, String outString) {
        this(inString, outString, true);
    }

    public Yaml(String inString, String outString, boolean isPostProcessingEnabled) {
        this.inString = inString;
        this.outString = outString;
        this.init(isPostProcessingEnabled);
    }

    public Yaml(File file) {
        this(file, true);
    }

    public Yaml(File file, boolean isPostProcessingEnabled) {
        this.file = file;
        this.init(isPostProcessingEnabled);
    }

    public Yaml(String filePath) {
        this(filePath, true);
    }

    public Yaml(String filePath, boolean isPostProcessingEnabled) {
        this.file = new File(filePath);
        this.init(isPostProcessingEnabled);
    }

    private void init(boolean isPostProcessingEnabled) {
        this.isPostProcessingEnabled = isPostProcessingEnabled;
    }

    public Yaml load() throws IOException, YamlReaderException, IllegalListException, DuplicateKeyException {
        if (this.file != null && !this.file.exists()) {
            if (this.file.getParentFile() != null) {
                this.file.getParentFile().mkdirs();
            }
            this.file.createNewFile();
        }
        new YamlReader().parse(this);
        this.isLoaded = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockFile() {
        if (this.file != null) {
            ReentrantLock lock;
            Map<String, ReentrantLock> map = pathsAndLocks;
            synchronized (map) {
                if (pathsAndLocks.containsKey(this.file.getAbsolutePath())) {
                    lock = pathsAndLocks.get(this.file.getAbsolutePath());
                } else {
                    lock = new ReentrantLock();
                    pathsAndLocks.put(this.file.getAbsolutePath(), lock);
                }
            }
            lock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockFile() {
        if (this.file != null) {
            Map<String, ReentrantLock> map = pathsAndLocks;
            synchronized (map) {
                if (pathsAndLocks.containsKey(this.file.getAbsolutePath())) {
                    ReentrantLock lock = pathsAndLocks.get(this.file.getAbsolutePath());
                    lock.unlock();
                    if (!lock.hasQueuedThreads()) {
                        pathsAndLocks.remove(this.file.getAbsolutePath());
                    }
                }
            }
        }
    }

    public Yaml reset() throws IOException, DuplicateKeyException, YamlReaderException, IllegalListException, YamlWriterException {
        if (this.inputStream == null) {
            if (!this.isLoaded) {
                this.load();
            }
            new YamlWriter().parse(this, true, true);
            this.load();
        }
        return this;
    }

    public Yaml saveAndLoad() throws IOException, DuplicateKeyException, YamlReaderException, IllegalListException, YamlWriterException {
        if (!this.isLoaded) {
            this.load();
        }
        this.save();
        this.load();
        return this;
    }

    public Yaml save() throws YamlWriterException, IOException, DuplicateKeyException, YamlReaderException, IllegalListException {
        this.save(false);
        return this;
    }

    public Yaml save(boolean overwrite) throws IOException, DuplicateKeyException, YamlReaderException, IllegalListException, YamlWriterException {
        if (!this.isLoaded) {
            this.load();
        }
        new YamlWriter().parse(this, overwrite, false);
        return this;
    }

    public YamlSection get(String ... keys) {
        Objects.requireNonNull(keys);
        return this.get(Arrays.asList(keys));
    }

    public YamlSection get(List<String> keys) {
        Objects.requireNonNull(keys);
        YamlSection module = this.utilsYamlSection.getExisting(keys, this.inEditModules);
        if (module == null && (module = this.utilsYamlSection.getExisting(keys, this.loadedModules)) != null) {
            this.inEditModules.add(module);
        }
        return module;
    }

    public YamlSection put(String ... keys) throws NotLoadedException, IllegalKeyException {
        Objects.requireNonNull(keys);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(keys));
        return this.put(list);
    }

    public YamlSection put(List<String> keys) throws NotLoadedException, IllegalKeyException {
        Objects.requireNonNull(keys);
        YamlSection section = this.utilsYamlSection.getExisting(keys, this.inEditModules);
        if (section != null) {
            return section;
        }
        section = this.utilsYamlSection.getExisting(keys, this.loadedModules);
        if (section != null) {
            this.inEditModules.add(section);
            return section;
        }
        try {
            return this.add(keys);
        }
        catch (IllegalKeyException | NotLoadedException e) {
            throw e;
        }
        catch (DuplicateKeyException duplicateKeyException) {
            return section;
        }
    }

    public YamlSection add(String ... keys) throws NotLoadedException, IllegalKeyException, DuplicateKeyException {
        Objects.requireNonNull(keys);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(keys));
        return this.add(list);
    }

    public YamlSection add(List<String> keys) throws NotLoadedException, IllegalKeyException, DuplicateKeyException {
        Objects.requireNonNull(keys);
        return this.add(keys, null, null, null);
    }

    public YamlSection add(List<String> keys, List<SmartString> defaultValues, List<SmartString> values, List<String> comments) throws NotLoadedException, IllegalKeyException, DuplicateKeyException {
        return this.add(new YamlSection(this, keys, defaultValues, values, comments));
    }

    public YamlSection add(YamlSection module) throws IllegalKeyException, NotLoadedException, DuplicateKeyException {
        Objects.requireNonNull(module);
        Objects.requireNonNull(module.getKeys());
        if (module.getKeys().isEmpty()) {
            throw new IllegalKeyException("Keys list of this module cannot be empty!");
        }
        if (!this.isLoaded) {
            throw new NotLoadedException();
        }
        if (module.getKeys().contains(null)) {
            throw new IllegalKeyException("The provided keys list contains null key(s)! This is not allowed!");
        }
        if (this.utilsYamlSection.getExisting(module, this.inEditModules) != null) {
            throw new DuplicateKeyException(this.getSource().toString(), module.getKeys().toString());
        }
        if (this.utilsYamlSection.getExisting(module, this.loadedModules) != null) {
            throw new DuplicateKeyException(this.getSource().toString(), module.getKeys().toString());
        }
        int closestParentIndex = this.utilsYamlSection.getClosestParentIndex(module.getKeys(), this.inEditModules);
        if (closestParentIndex == -1) {
            this.inEditModules.add(module);
            return module;
        }
        if (closestParentIndex + 1 <= this.inEditModules.size()) {
            this.inEditModules.add(closestParentIndex + 1, module);
            return module;
        }
        this.inEditModules.add(module);
        return module;
    }

    public YamlSection replace(YamlSection moduleToReplace, YamlSection newModule) {
        Objects.requireNonNull(moduleToReplace);
        Objects.requireNonNull(newModule);
        YamlSection module = this.utilsYamlSection.getExisting(moduleToReplace, this.inEditModules);
        if (module == null) {
            module = this.utilsYamlSection.getExisting(moduleToReplace, this.loadedModules);
            if (module != null) {
                this.inEditModules.add(newModule);
            }
        } else {
            int i = this.inEditModules.indexOf(moduleToReplace);
            this.inEditModules.remove(moduleToReplace);
            this.inEditModules.add(i, newModule);
        }
        return module;
    }

    public Yaml remove(String ... keys) {
        Objects.requireNonNull(keys);
        this.remove(new YamlSection(this, keys));
        return this;
    }

    public void removeAll() {
        this.inEditModules.clear();
        this.loadedModules.clear();
    }

    public Yaml remove(YamlSection module) {
        YamlSection loadedM;
        YamlSection addedM = this.utilsYamlSection.getExisting(module, this.inEditModules);
        if (addedM != null) {
            this.inEditModules.remove(addedM);
        }
        if ((loadedM = this.utilsYamlSection.getExisting(module, this.loadedModules)) != null) {
            this.loadedModules.remove(loadedM);
        }
        return this;
    }

    public Yaml addFileEventListener(Consumer<FileEvent> listener) throws IOException {
        if (this.watcher == null) {
            this.watcher = DirWatcher.get(this.file, false);
        }
        this.watcher.watchFile(this.file, listener);
        return this;
    }

    public Yaml removeFileEventListener(Consumer<FileEvent> listener) throws Exception {
        Objects.requireNonNull(this.watcher);
        this.watcher.removeListeners(listener);
        return this;
    }

    public List<YamlSection> createUnifiedList(List<YamlSection> inEditModules, List<YamlSection> loadedModules) {
        if (loadedModules.isEmpty()) {
            return inEditModules;
        }
        CopyOnWriteArrayList<YamlSection> copyInEditModules = new CopyOnWriteArrayList<YamlSection>(inEditModules);
        ArrayList<YamlSection> unifiedList = new ArrayList<YamlSection>();
        for (YamlSection loadedModule : loadedModules) {
            YamlSection existing = this.utilsYamlSection.getExisting(loadedModule, copyInEditModules);
            if (existing != null) {
                unifiedList.add(existing);
                copyInEditModules.remove(existing);
                continue;
            }
            unifiedList.add(loadedModule);
        }
        for (YamlSection newModule : copyInEditModules) {
            if (newModule.getKeys().size() > 1) {
                int currentIndex = 0;
                int bestMatchIndex = 0;
                int highestCountOfMatchingKeys = 0;
                for (YamlSection unifiedModule : unifiedList) {
                    for (int j = 0; j < unifiedModule.getKeys().size() && unifiedModule.getKeys().get(j).equals(newModule.getKeys().get(j)); ++j) {
                        if (j + 1 < highestCountOfMatchingKeys) continue;
                        bestMatchIndex = currentIndex;
                        highestCountOfMatchingKeys = j + 1;
                    }
                    ++currentIndex;
                }
                if (highestCountOfMatchingKeys != newModule.getKeys().size() - 1) {
                    YamlSection beforeFillerModule = null;
                    for (int i = highestCountOfMatchingKeys; i < newModule.getKeys().size() - 1; ++i) {
                        YamlSection fillerModule = new YamlSection(this, newModule.getKeys().subList(0, i), null, null, null);
                        unifiedList.add(++bestMatchIndex, fillerModule);
                        if (beforeFillerModule != null) {
                            beforeFillerModule.addChildSections(fillerModule);
                            fillerModule.setParentSection(beforeFillerModule);
                        }
                        beforeFillerModule = fillerModule;
                    }
                }
                try {
                    YamlSection parent = (YamlSection)unifiedList.get(bestMatchIndex);
                    unifiedList.add(++bestMatchIndex, newModule);
                    parent.addChildSections(newModule);
                    newModule.setParentSection(parent);
                }
                catch (Exception e) {
                    unifiedList.add(0, newModule);
                }
                continue;
            }
            unifiedList.add(0, newModule);
        }
        return unifiedList;
    }

    public List<YamlSection> getAll() {
        return this.createUnifiedList(this.inEditModules, this.loadedModules);
    }

    public List<YamlSection> getAllLoaded() {
        return this.loadedModules;
    }

    public YamlSection getLastLoadedModule() {
        return this.loadedModules.get(this.loadedModules.size() - 1);
    }

    public List<YamlSection> getAllInEdit() {
        return this.inEditModules;
    }

    public YamlSection getLastInEditModule() {
        return this.inEditModules.get(this.inEditModules.size() - 1);
    }

    public Yaml printAll() {
        this.printLoaded();
        this.printInEdit();
        this.printUnified();
        System.out.println();
        return this;
    }

    public Yaml printLoaded() {
        this.utilsYaml.printLoaded(System.out);
        return this;
    }

    public Yaml printInEdit() {
        this.utilsYaml.printInEdit(System.out);
        return this;
    }

    public Yaml printUnified() {
        this.utilsYaml.printUnified(System.out);
        return this;
    }

    public Yaml printFile() {
        Objects.requireNonNull(this.file);
        this.utilsFile.printFile(this.file);
        return this;
    }

    public String getFilePath() {
        return this.file != null ? this.file.getAbsolutePath() : "";
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public UtilsYaml getUtilsDreamYaml() {
        return this.utilsYaml;
    }

    public String getFileNameWithoutExt() throws NotLoadedException {
        if (this.inputStream != null) {
            return "<InputStream>";
        }
        if (!this.isLoaded) {
            throw new NotLoadedException();
        }
        return this.file.getName().replaceFirst("[.][^.]+$", "");
    }

    public Object getSource() {
        if (this.file != null) {
            return this.file;
        }
        if (this.inString != null) {
            return this.inString;
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        return null;
    }
}

