/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.yml;

import com.mohistmc.yml.SmartString;
import com.mohistmc.yml.Yaml;
import com.mohistmc.yml.exceptions.IllegalKeyException;
import com.mohistmc.yml.exceptions.NotLoadedException;
import com.mohistmc.yml.utils.UtilsYamlSection;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class YamlSection {
    private final UtilsYamlSection utils = new UtilsYamlSection();
    private Yaml yaml;
    private List<String> keys;
    private List<SmartString> values;
    private List<SmartString> defaultValues;
    private List<String> comments;
    private List<String> defaultComments;
    private List<String> sideComments;
    private List<String> defaultSideComments;
    private int countTopLineBreaks;
    private YamlSection parentSection = null;
    private List<YamlSection> childSections = new ArrayList<YamlSection>();

    public YamlSection(Yaml yaml) {
        this(yaml, (String[])null);
    }

    public YamlSection(Yaml yaml, String ... keys) {
        ArrayList<String> list = new ArrayList<String>();
        if (keys != null) {
            list.addAll(Arrays.asList(keys));
        }
        this.init(yaml, list, null, null, null);
    }

    public YamlSection(Yaml yaml, List<String> keys, List<SmartString> defaultValues, List<SmartString> values, List<String> comments) {
        this.init(yaml, keys, defaultValues, values, comments);
    }

    private void init(Yaml yaml, List<String> keys, List<SmartString> defaultValues, List<SmartString> values, List<String> comments) {
        this.yaml = yaml;
        this.keys = keys;
        this.values = values;
        this.defaultValues = defaultValues;
        this.comments = comments;
        if (keys == null) {
            this.keys = new ArrayList<String>();
        }
        if (defaultValues == null) {
            this.defaultValues = new ArrayList<SmartString>();
        }
        if (values == null) {
            this.values = new ArrayList<SmartString>();
        }
        if (comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.defaultComments = new ArrayList<String>(1);
        this.sideComments = new ArrayList<String>(1);
        this.defaultSideComments = new ArrayList<String>(1);
    }

    public Yaml getYaml() {
        return this.yaml;
    }

    public YamlSection print() {
        System.out.println(this.toPrintString());
        return this;
    }

    public String toPrintString() {
        String s = "KEYS: " + this.getKeys().toString() + " VALUES: " + this.utils.valuesListToStringList(this.getValues()).toString() + " DEF-VALUES: " + this.utils.valuesListToStringList(this.getDefValues()).toString() + " COMMENTS: " + this.getComments().toString() + " SIDE-COMMENTS: " + this.getSideComments().toString();
        return s;
    }

    public YamlSection removeAllKeys() {
        this.keys.clear();
        return this;
    }

    public YamlSection removeAllValues() {
        this.values.clear();
        return this;
    }

    public YamlSection removeAllDefValues() {
        this.defaultValues.clear();
        return this;
    }

    public YamlSection removeAllComments() {
        this.comments.clear();
        return this;
    }

    public YamlSection addKeys(String ... keys) {
        for (String key : keys) {
            Objects.requireNonNull(key);
            this.keys.add(key);
        }
        return this;
    }

    public <T> YamlSection addValues(T ... v) {
        if (v != null) {
            this.addSValues(this.utils.arrayToValuesList(v));
        } else {
            this.addSValues(null);
        }
        return this;
    }

    public YamlSection addValues(SmartString ... v) {
        if (v != null) {
            this.addSValues(Arrays.asList(v));
        } else {
            this.addSValues(null);
        }
        return this;
    }

    public <T> YamlSection addValues(List<T> v) {
        this.addSValues(this.utils.listToValuesList(v));
        return this;
    }

    public YamlSection addSValues(List<SmartString> v) {
        if (v != null) {
            for (SmartString value : v) {
                Objects.requireNonNull(value);
            }
            this.values.addAll(v);
        } else {
            this.values.add(new SmartString(null));
        }
        return this;
    }

    public YamlSection addComments(String ... c) {
        if (c != null) {
            this.comments.addAll(Arrays.asList(c));
        }
        return this;
    }

    public YamlSection addSideComments(String ... c) {
        if (c != null) {
            this.sideComments.addAll(Arrays.asList(c));
        }
        return this;
    }

    public <T> YamlSection addDefValues(T ... v) {
        if (v != null) {
            this.addDefSValues(this.utils.arrayToValuesList(v));
        } else {
            this.addDefSValues(null);
        }
        return this;
    }

    public YamlSection addDefValues(SmartString ... v) {
        if (v != null) {
            this.addDefSValues(Arrays.asList(v));
        } else {
            this.addDefSValues(null);
        }
        return this;
    }

    public <T> YamlSection addDefValues(List<T> v) {
        this.addDefSValues(this.utils.listToValuesList(v));
        return this;
    }

    public YamlSection addDefSValues(List<SmartString> v) {
        if (v != null) {
            for (SmartString value : v) {
                Objects.requireNonNull(value);
            }
            this.defaultValues.addAll(v);
        } else {
            this.defaultValues.add(new SmartString(null));
        }
        return this;
    }

    public YamlSection addDefComments(String ... c) {
        if (c != null) {
            this.defaultComments.addAll(Arrays.asList(c));
        }
        return this;
    }

    public YamlSection addDefSideComments(String ... c) {
        if (c != null) {
            this.defaultSideComments.addAll(Arrays.asList(c));
        }
        return this;
    }

    public UtilsYamlSection getUtils() {
        return this.utils;
    }

    public String getFirstKey() {
        return this.getKeyAt(0);
    }

    public String getLastKey() {
        return this.getKeyAt(this.keys.size() - 1);
    }

    public SmartString getLastValue() {
        return this.getValueAt(this.values.size() - 1);
    }

    public SmartString getLastDefValue() {
        return this.getValueAt(this.defaultValues.size() - 1);
    }

    public String getKeyAt(int i) {
        try {
            return this.keys.get(i);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public YamlSection setKeys(String ... keys) {
        if (keys != null) {
            return this.setKeys(Arrays.asList(keys));
        }
        return this;
    }

    public YamlSection setKeys(List<String> keys) {
        if (keys != null) {
            this.keys.clear();
            this.keys.addAll(keys);
        }
        return this;
    }

    public SmartString getValue() {
        return this.getValueAt(0);
    }

    public SmartString getValueAt(int i) {
        SmartString v = new SmartString(null);
        try {
            v = this.values.get(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (v.asString() == null && this.yaml.isReturnDefaultWhenValueIsNullEnabled) {
            return this.getDefValueAt(i);
        }
        return v;
    }

    public List<SmartString> getValues() {
        if (this.values.isEmpty() && this.yaml.isReturnDefaultWhenValueIsNullEnabled) {
            return this.getDefValues();
        }
        return this.values;
    }

    public <T> YamlSection setValues(T ... v) {
        this.setSValues(this.utils.arrayToValuesList(v));
        return this;
    }

    public <T> YamlSection setValues(List<T> v) {
        this.setSValues(this.utils.listToValuesList(v));
        return this;
    }

    public YamlSection setSValues(SmartString ... v) {
        this.setSValues(Arrays.asList(v));
        return this;
    }

    public YamlSection setSValues(List<SmartString> v) {
        this.values.clear();
        this.addSValues(v);
        return this;
    }

    public SmartString getDefValue() {
        return this.getDefValueAt(0);
    }

    public SmartString getDefValueAt(int i) {
        SmartString v = new SmartString(null);
        try {
            v = this.defaultValues.get(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public List<SmartString> getDefValues() {
        return this.defaultValues;
    }

    public <T> YamlSection setDefValues(T ... v) {
        this.setDefSValues(this.utils.arrayToValuesList(v));
        return this;
    }

    public <T> YamlSection setDefValues(List<T> v) {
        this.setDefSValues(this.utils.listToValuesList(v));
        return this;
    }

    public YamlSection setDefSmartValues(SmartString ... v) {
        this.setDefSValues(Arrays.asList(v));
        return this;
    }

    public YamlSection setDefSValues(List<SmartString> v) {
        this.defaultValues.clear();
        return this.addDefSValues(v);
    }

    public String getComment() {
        return this.getCommentAt(0);
    }

    public String getCommentAt(int i) {
        try {
            return this.comments.get(i);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<String> getComments() {
        return this.comments;
    }

    public YamlSection setComments(String ... c) {
        if (c != null) {
            this.setComments(Arrays.asList(c));
        }
        return this;
    }

    public YamlSection setComments(List<String> c) {
        if (c != null) {
            this.comments.clear();
            this.comments.addAll(c);
        }
        return this;
    }

    public String getDefComment() {
        return this.getDefCommentAt(0);
    }

    public String getDefCommentAt(int i) {
        try {
            return this.defaultComments.get(i);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<String> getDefComments() {
        return this.defaultComments;
    }

    public YamlSection setDefComments(String ... c) {
        if (c != null) {
            this.setDefComments(Arrays.asList(c));
        }
        return this;
    }

    public YamlSection setDefComments(List<String> c) {
        if (c != null) {
            this.defaultComments.clear();
            this.defaultComments.addAll(c);
        }
        return this;
    }

    public String getSideComment() {
        return this.getSideCommentAt(0);
    }

    public String getSideCommentAt(int i) {
        try {
            return this.sideComments.get(i);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<String> getSideComments() {
        return this.sideComments;
    }

    public YamlSection setSideComments(String ... c) {
        if (c != null) {
            this.setSideComments(Arrays.asList(c));
        }
        return this;
    }

    public YamlSection setSideComments(List<String> c) {
        if (c != null) {
            this.sideComments.clear();
            this.sideComments.addAll(c);
        }
        return this;
    }

    public String getDefSideComment() {
        return this.getDefSideCommentAt(0);
    }

    public String getDefSideCommentAt(int i) {
        try {
            return this.defaultSideComments.get(i);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<String> getDefSideComments() {
        return this.defaultSideComments;
    }

    public YamlSection setDefSideComments(String ... c) {
        if (c != null) {
            this.setDefSideComments(Arrays.asList(c));
        }
        return this;
    }

    public YamlSection setDefSideComments(List<String> c) {
        if (c != null) {
            this.defaultSideComments.clear();
            this.defaultSideComments.addAll(c);
        }
        return this;
    }

    public YamlSection putJavaChildSection(Object obj) throws NotLoadedException, IllegalKeyException, IllegalAccessException {
        return this.putJavaChildSection(this, obj, false);
    }

    public YamlSection putJavaChildSection(Object obj, boolean includePrivateFields) throws NotLoadedException, IllegalKeyException, IllegalAccessException {
        return this.putJavaChildSection(this, obj, includePrivateFields);
    }

    public YamlSection putJavaChildSection(YamlSection section, Object obj, boolean includePrivateFields) throws NotLoadedException, IllegalKeyException, IllegalAccessException {
        Class<?> aClass = obj.getClass();
        if (aClass.isEnum()) {
            section.setValues(((Enum)obj).name());
        } else {
            for (Field field : aClass.getDeclaredFields()) {
                Object rawValue;
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (!includePrivateFields) continue;
                    field.setAccessible(true);
                }
                if ((rawValue = field.get(obj)) == null) continue;
                ArrayList<String> keys = new ArrayList<String>(section.keys);
                keys.add(field.getName());
                YamlSection childSection = this.yaml.put(keys);
                if (this.isPrimitive(rawValue.getClass()) || this.isText(rawValue.getClass())) {
                    String value = "" + rawValue;
                    childSection.setValues(value);
                    continue;
                }
                this.putJavaChildSection(childSection, rawValue, includePrivateFields);
            }
        }
        return this;
    }

    public YamlSection putDefJavaChildSection(Object obj) throws NotLoadedException, IllegalKeyException, IllegalAccessException {
        return this.putDefJavaChildSection(this, obj, false);
    }

    public YamlSection putDefJavaChildSection(Object obj, boolean includePrivateFields) throws NotLoadedException, IllegalKeyException, IllegalAccessException {
        return this.putDefJavaChildSection(this, obj, includePrivateFields);
    }

    public YamlSection putDefJavaChildSection(YamlSection section, Object obj, boolean includePrivateFields) throws NotLoadedException, IllegalKeyException, IllegalAccessException {
        Class<?> aClass = obj.getClass();
        if (aClass.isEnum()) {
            this.setDefValues(((Enum)obj).name());
        } else {
            for (Field field : aClass.getDeclaredFields()) {
                Object rawValue;
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (!includePrivateFields) continue;
                    field.setAccessible(true);
                }
                if ((rawValue = field.get(obj)) == null) continue;
                ArrayList<String> keys = new ArrayList<String>(section.keys);
                keys.add(field.getName());
                YamlSection childSection = this.yaml.put(keys);
                if (this.isPrimitive(rawValue.getClass()) || this.isText(rawValue.getClass())) {
                    String value = "" + rawValue;
                    childSection.setDefValues(value);
                    continue;
                }
                this.putDefJavaChildSection(childSection, rawValue, includePrivateFields);
            }
        }
        return this;
    }

    public <V> V as(Class<V> type) throws InstantiationException, IllegalAccessException, NotLoadedException, IllegalKeyException, InvocationTargetException {
        return this.as(this, type, false);
    }

    public <V> V as(Class<V> type, boolean includePrivateFields) throws InstantiationException, IllegalAccessException, NotLoadedException, IllegalKeyException, InvocationTargetException {
        return this.as(this, type, includePrivateFields);
    }

    public <V> V as(YamlSection section, Class<V> type, boolean includePrivateFields) throws InstantiationException, IllegalAccessException, NotLoadedException, IllegalKeyException, InvocationTargetException {
        Object instance;
        if (type.isEnum()) {
            if (section.asString() == null) {
                return null;
            }
            return Enum.valueOf(type, section.asString());
        }
        if (type.getDeclaredConstructors().length == 0) {
            instance = type.newInstance();
        } else {
            Constructor constructor = this.getTopConstructor(type);
            Parameter[] params = constructor.getParameters();
            if (params.length > 0) {
                Object[] paramValues = new Object[params.length];
                for (int i = 0; i < params.length; ++i) {
                    paramValues[i] = 0;
                    paramValues[i] = this.isPrimitive(params[i].getType()) ? Integer.valueOf(0) : null;
                }
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    constructor.setAccessible(true);
                }
                instance = constructor.newInstance(paramValues);
            } else {
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    constructor.setAccessible(true);
                }
                instance = constructor.newInstance(new Object[0]);
            }
        }
        for (Field field : type.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers())) {
                if (!includePrivateFields) continue;
                field.setAccessible(true);
            }
            YamlSection childSection = null;
            for (YamlSection cs : section.getChildSections()) {
                if (!cs.getLastKey().equals(field.getName())) continue;
                childSection = cs;
                break;
            }
            if (childSection == null) continue;
            if (field.getType().equals(String.class) || field.getType().equals(Character.class)) {
                field.set(instance, childSection.asString());
                continue;
            }
            if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                field.set(instance, childSection.asBoolean());
                continue;
            }
            if (field.getType().equals(Byte.TYPE) || field.getType().equals(Byte.class)) {
                field.set(instance, childSection.asByte());
                continue;
            }
            if (field.getType().equals(Short.TYPE) || field.getType().equals(Short.class)) {
                field.set(instance, childSection.asShort());
                continue;
            }
            if (field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) {
                field.set(instance, childSection.asInt());
                continue;
            }
            if (field.getType().equals(Long.TYPE) || field.getType().equals(Long.class)) {
                field.set(instance, childSection.asLong());
                continue;
            }
            if (field.getType().equals(Float.TYPE) || field.getType().equals(Float.class)) {
                field.set(instance, Float.valueOf(childSection.asFloat()));
                continue;
            }
            if (field.getType().equals(Double.TYPE) || field.getType().equals(Double.class)) {
                field.set(instance, childSection.asDouble());
                continue;
            }
            field.set(instance, this.as(childSection, field.getType(), includePrivateFields));
        }
        return instance;
    }

    private Constructor getTopConstructor(Class<?> clazz) {
        Constructor<?> result = null;
        for (Constructor<?> c : clazz.getDeclaredConstructors()) {
            if (result == null) {
                result = c;
                continue;
            }
            if (c.getParameterCount() >= result.getParameterCount()) continue;
            result = c;
        }
        return result;
    }

    private boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.equals(Boolean.class) || clazz.equals(Byte.class) || clazz.equals(Short.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Float.class) || clazz.equals(Double.class) || clazz.equals(Character.class);
    }

    private boolean isText(Class<?> clazz) {
        return clazz.equals(String.class) || clazz.equals(CharSequence.class);
    }

    public String asString() {
        return this.asString(0);
    }

    public String asString(int i) {
        return this.getValueAt(i).asString();
    }

    public SmartString asSmartString() {
        return this.asSmartString(0);
    }

    public SmartString asSmartString(int i) {
        return this.getValueAt(i);
    }

    public List<String> asStringList() {
        return this.utils.valuesListToStringList(this.getValues());
    }

    public char[] asCharArray() {
        return this.asCharArray(0);
    }

    public char[] asCharArray(int i) {
        return this.getValueAt(i).asCharArray();
    }

    public boolean asBoolean() {
        return this.asBoolean(0);
    }

    public boolean asBoolean(int i) {
        return this.getValueAt(i).asBoolean();
    }

    public byte asByte() {
        return this.asByte(0);
    }

    public byte asByte(int i) {
        return this.getValueAt(i).asByte();
    }

    public short asShort() {
        return this.asShort(0);
    }

    public short asShort(int i) {
        return this.getValueAt(i).asShort();
    }

    public int asInt() {
        return this.asInt(0);
    }

    public int asInt(int i) {
        return this.getValueAt(i).asInt();
    }

    public long asLong() {
        return this.asLong(0);
    }

    public long asLong(int i) {
        return this.getValueAt(i).asLong();
    }

    public float asFloat() {
        return this.asFloat(0);
    }

    public float asFloat(int i) {
        return this.getValueAt(i).asFloat().floatValue();
    }

    public Double asDouble() {
        return this.asDouble(0);
    }

    public Double asDouble(int i) {
        return this.getValueAt(i).asDouble();
    }

    public YamlSection getParentSection() {
        return this.parentSection;
    }

    public YamlSection setParentSection(YamlSection parentSection) {
        this.parentSection = parentSection;
        return this;
    }

    public List<YamlSection> getChildSections() {
        return this.childSections;
    }

    public YamlSection setChildSections(List<YamlSection> childSections) {
        this.childSections = childSections;
        return this;
    }

    public YamlSection addChildSections(YamlSection ... cModules) {
        Objects.requireNonNull(cModules);
        this.childSections.addAll(Arrays.asList(cModules));
        return this;
    }

    public int getCountTopLineBreaks() {
        return this.countTopLineBreaks;
    }

    public YamlSection setCountTopLineBreaks(int countTopLineBreaks) {
        this.countTopLineBreaks = countTopLineBreaks;
        return this;
    }
}

