/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;

public class FileUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readFileFromJar(ClassLoader classLoader, String path) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(path)));){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static void deleteFolders(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                FileUtils.deleteFolders(f);
            }
        }
        file.delete();
    }

    public static boolean fileExists(File f, String fName) {
        if (!f.exists()) {
            return false;
        }
        try {
            JarFile jf = new JarFile(f);
            if (jf.getJarEntry(fName) != null) {
                jf.close();
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static void fileWriterMethod(String filepath, String content) {
        try (FileWriter fileWriter = new FileWriter(filepath);){
            fileWriter.append(content);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

