/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.yml.db;

import com.mohistmc.yml.Yaml;
import com.mohistmc.yml.db.YamlTable;
import com.mohistmc.yml.exceptions.DuplicateKeyException;
import com.mohistmc.yml.exceptions.IllegalKeyException;
import com.mohistmc.yml.exceptions.IllegalListException;
import com.mohistmc.yml.exceptions.NotLoadedException;
import com.mohistmc.yml.exceptions.YamlReaderException;
import com.mohistmc.yml.exceptions.YamlWriterException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class YamlDatabase {
    public List<YamlTable> tables = new CopyOnWriteArrayList<YamlTable>();
    public Thread threadAutoSave;
    private Yaml yaml;

    public YamlDatabase() {
        String name = "DreamYaml-DB-" + new Random().nextInt(10000000);
        File yamlFile = null;
        for (int i = 1; i < 11; ++i) {
            try {
                yamlFile = new File(System.getProperty("user.dir") + "/" + name + ".yml");
                if (!yamlFile.exists()) break;
                name = "DreamYaml-DB-" + new Random().nextInt(10000000);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.init(yamlFile);
    }

    public YamlDatabase(String name) {
        this.init(new File(System.getProperty("user.dir") + "/" + name + ".yml"));
    }

    public YamlDatabase(Path yamlFilePath) {
        this.init(yamlFilePath.toFile());
    }

    public YamlDatabase(File yamlFile) {
        this.init(yamlFile);
    }

    public YamlDatabase(Yaml yaml) {
        this.init(yaml);
    }

    private void init(File yamlFile) {
        this.init(new Yaml(yamlFile));
    }

    private void init(Yaml yaml) {
        Objects.requireNonNull(yaml);
        this.yaml = yaml;
        yaml.isRemoveLoadedNullValuesEnabled = false;
    }

    public void initAutoSaveThread(long msIntervall, Consumer<Exception> onException) {
        if (this.threadAutoSave == null || this.threadAutoSave.isInterrupted()) {
            this.threadAutoSave = new Thread(() -> {
                try {
                    while (true) {
                        Thread.sleep(msIntervall);
                        this.save();
                    }
                }
                catch (Exception e) {
                    onException.accept(e);
                    return;
                }
            });
        }
    }

    public Yaml getYaml() {
        return this.yaml;
    }

    public YamlDatabase load() throws IOException, DuplicateKeyException, YamlReaderException, IllegalListException {
        this.yaml.load();
        return this;
    }

    public YamlDatabase save() throws YamlWriterException, IOException, DuplicateKeyException, YamlReaderException, IllegalListException {
        this.yaml.save();
        return this;
    }

    public YamlDatabase saveAndLoad() throws YamlWriterException, IOException, DuplicateKeyException, YamlReaderException, IllegalListException {
        this.yaml.saveAndLoad();
        return this;
    }

    public YamlTable addTable(String name) throws NotLoadedException, IllegalKeyException, DuplicateKeyException, YamlWriterException, IOException, YamlReaderException, IllegalListException {
        YamlTable table = new YamlTable(this.yaml.add("tables", name));
        this.yaml.saveAndLoad();
        this.tables.add(table);
        return table;
    }

    public YamlTable putTable(String name) throws NotLoadedException, IllegalKeyException, YamlWriterException, IOException, DuplicateKeyException, YamlReaderException, IllegalListException {
        this.yaml.saveAndLoad();
        YamlTable tExisting = null;
        for (YamlTable t : this.tables) {
            if (!t.getName().equals(name)) continue;
            tExisting = t;
            break;
        }
        if (tExisting == null) {
            YamlTable newTable = new YamlTable(this.yaml.put("tables", name));
            this.tables.add(newTable);
            return newTable;
        }
        return tExisting;
    }

    public YamlDatabase removeTable(YamlTable table) {
        Objects.requireNonNull(table);
        this.yaml.remove("tables", table.getName());
        YamlTable tRemove = null;
        for (YamlTable t : this.tables) {
            if (!table.equals(t) && !t.getName().equals(table.getName())) continue;
            tRemove = t;
            break;
        }
        if (tRemove != null) {
            this.tables.remove(tRemove);
        }
        return this;
    }

    public YamlTable getTable(String name) {
        List<YamlTable> tables = this.getTables();
        for (YamlTable t : tables) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public YamlTable getTableAtIndex(int index) {
        return this.getTables().get(index);
    }

    public List<YamlTable> getTables() {
        return this.tables;
    }
}

