/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc;

import com.mohistmc.action.v_1_20_1;
import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.feature.AutoDeleteMods;
import com.mohistmc.feature.CustomLibraries;
import com.mohistmc.feature.DefaultLibraries;
import com.mohistmc.i18n.i18n;
import com.mohistmc.tools.JarTool;
import com.mohistmc.tools.Logo;
import com.mohistmc.util.DataParser;
import com.mohistmc.util.EulaUtil;
import com.mohistmc.util.MohistModuleManager;
import com.mohistmc.util.UpdateUtils;
import cpw.mods.bootstraplauncher.BootstrapLauncher;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Stream;

public class MohistMCStart {
    public static final List<String> mainArgs = new ArrayList<String>();
    public static String MCVERSION;
    public static i18n i18n;
    public static JarTool jarTool;

    public static String getVersion() {
        return MohistMCStart.class.getPackage().getImplementationVersion() != null ? MohistMCStart.class.getPackage().getImplementationVersion() : "unknown";
    }

    public static void main(String[] args) throws Exception {
        mainArgs.addAll(List.of(args));
        jarTool = new JarTool(MohistMCStart.class);
        DataParser.parseVersions();
        DataParser.parseLaunchArgs();
        MohistConfigUtil.init();
        MohistConfigUtil.i18n();
        if (!MohistConfigUtil.INSTALLATIONFINISHED.asBoolean() && MohistConfigUtil.SHOW_LOGO.asBoolean()) {
            System.out.printf("%n%s%n%s - %s, Java(%s) %s PID: %s%n", Logo.asMohist(), i18n.as("mohist.launch.welcomemessage"), MohistMCStart.getVersion(), System.getProperty("java.version"), System.getProperty("java.class.version"), ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
        }
        if (System.getProperty("log4j.configurationFile") == null) {
            System.setProperty("log4j.configurationFile", "log4j2_mohist.xml");
        }
        if (!MohistConfigUtil.INSTALLATIONFINISHED.asBoolean() && MohistConfigUtil.CHECK_UPDATE.asBoolean()) {
            UpdateUtils.versionCheck();
        }
        if (!MohistConfigUtil.INSTALLATIONFINISHED.asBoolean() && MohistConfigUtil.CHECK_LIBRARIES.asBoolean()) {
            DefaultLibraries.run();
        }
        if (!MohistConfigUtil.INSTALLATIONFINISHED.asBoolean()) {
            v_1_20_1.run();
        }
        AutoDeleteMods.jar();
        CustomLibraries.loadCustomLibs();
        ArrayList<String> forgeArgs = new ArrayList<String>();
        for (String arg : DataParser.launchArgs.stream().filter(s -> s.startsWith("--launchTarget") || s.startsWith("--fml.forgeVersion") || s.startsWith("--fml.mcVersion") || s.startsWith("--fml.forgeGroup") || s.startsWith("--fml.mcpVersion")).toList()) {
            forgeArgs.add(arg.split(" ")[0]);
            forgeArgs.add(arg.split(" ")[1]);
        }
        new MohistModuleManager(DataParser.launchArgs);
        if (!EulaUtil.hasAcceptedEULA()) {
            System.out.println(i18n.as("eula"));
            while (!"true".equals(new Scanner(System.in).nextLine().trim())) {
                System.out.println(i18n.as("eula_notrue"));
            }
            EulaUtil.writeInfos();
        }
        String[] args_ = (String[])Stream.concat(forgeArgs.stream(), mainArgs.stream()).toArray(String[]::new);
        BootstrapLauncher.main((String[])args_);
    }
}

