/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.util;

import com.mohistmc.MohistMCStart;
import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.tools.ConnectionUtil;
import com.mohistmc.tools.NumberUtil;
import com.mohistmc.util.DataParser;
import com.mohistmc.util.I18n;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import mjson.Json;

public class UpdateUtils {
    public static void versionCheck() {
        System.out.println(I18n.as("update.check"));
        System.out.println(I18n.as("update.stopcheck"));
        try {
            Json json = Json.read(new URL("https://mohistmc.com/api/v2/sources/jenkins/Mohist-%s/builds/latest".formatted(MohistMCStart.MCVERSION)));
            int jar_version = Integer.parseInt(DataParser.versionMap.get("mohist"));
            int build_number = json.asInteger("id");
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(json.asLong("createdAt")));
            String url = json.asString("url");
            if (jar_version >= build_number) {
                System.out.println(I18n.as("update.latest", jar_version, build_number));
            } else {
                System.out.println(I18n.as("update.detect", build_number, jar_version, time));
                if (MohistConfigUtil.CHECK_UPDATE_AUTO_DOWNLOAD.asBoolean()) {
                    File mohistjar = MohistMCStart.jarTool.getFile();
                    System.out.println(I18n.as("download.file", mohistjar.getName(), NumberUtil.getSize(ConnectionUtil.getConn(url).getContentLength())));
                    ConnectionUtil.downloadFile(url, mohistjar);
                    System.out.println(I18n.as("download.file.ok", mohistjar.getName()));
                    UpdateUtils.restartServer(Arrays.asList("java", "-jar", MohistMCStart.jarTool.getJarName()), true);
                }
            }
        }
        catch (Throwable e) {
            System.out.println(I18n.as("check.update.noci"));
        }
    }

    public static void restartServer(List<String> cmd, boolean shutdown) throws Exception {
        System.out.println(I18n.as("jarfile.restart"));
        if (cmd.stream().anyMatch(s -> s.contains("-Xms"))) {
            System.out.println(I18n.as("xmswarn"));
        }
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.directory(MohistMCStart.jarTool.getJarDir());
        pb.inheritIO().start().waitFor();
        Thread.sleep(2000L);
        if (shutdown) {
            System.exit(0);
        }
    }
}

