/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.yml;

import com.mohistmc.yml.DYLine;
import com.mohistmc.yml.SmartString;
import com.mohistmc.yml.Yaml;
import com.mohistmc.yml.YamlSection;
import com.mohistmc.yml.exceptions.IllegalListException;
import com.mohistmc.yml.exceptions.YamlReaderException;
import com.mohistmc.yml.utils.UtilsTimeStopper;
import com.mohistmc.yml.utils.UtilsYamlSection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;

class YamlReader {
    private final List<DYLine> keyLinesList = new ArrayList<DYLine>();
    private DYLine beforeLine;
    private int countEmptyBeforeLines = 0;
    private YamlSection beforeModule;

    YamlReader() {
    }

    public void parse(Yaml yaml) throws YamlReaderException, IOException, IllegalListException {
        UtilsTimeStopper timer = new UtilsTimeStopper();
        timer.start();
        BufferedReader reader = null;
        try {
            String line;
            if (yaml.file != null) {
                if (!yaml.file.exists()) {
                    throw new YamlReaderException("File '" + yaml.file + "' doesn't exist!");
                }
                reader = new BufferedReader(new InputStreamReader(Files.newInputStream(yaml.file.toPath(), new OpenOption[0]), Yaml.charset));
            }
            if (yaml.inputStream != null) {
                reader = new BufferedReader(new InputStreamReader(yaml.inputStream, Yaml.charset));
            }
            if (yaml.inString != null) {
                reader = new BufferedReader(new StringReader(yaml.inString));
            }
            if (reader == null) {
                return;
            }
            yaml.getAllLoaded().clear();
            int lineNumber = 1;
            String firstLine = reader.readLine();
            if (firstLine == null) {
                firstLine = "";
            }
            DYLine firstDyLine = new DYLine(firstLine, lineNumber);
            this.parseFirstLine(yaml, firstDyLine);
            if (firstDyLine.isKeyFound()) {
                this.keyLinesList.add(firstDyLine);
            }
            this.beforeLine = firstDyLine;
            ++lineNumber;
            while ((line = reader.readLine()) != null) {
                String finalLine = line;
                int finalLineNumber = lineNumber;
                DYLine dyLine = new DYLine(finalLine, finalLineNumber);
                this.parseLine(yaml, dyLine);
                if (dyLine.isKeyFound()) {
                    this.keyLinesList.add(dyLine);
                }
                this.beforeLine = dyLine;
                ++lineNumber;
            }
            UtilsYamlSection utils = new UtilsYamlSection();
            for (YamlSection m : yaml.getAllLoaded()) {
                for (SmartString value : m.getValues()) {
                    value.isInsideQuotes = utils.isEncapsulatedInQuotes(value.asString());
                }
            }
            if (yaml.isPostProcessingEnabled) {
                if (yaml.isTrimLoadedValuesEnabled) {
                    for (YamlSection m : yaml.getAllLoaded()) {
                        utils.trimValues(m.getValues());
                    }
                }
                if (yaml.isRemoveQuotesFromLoadedValuesEnabled) {
                    for (YamlSection m : yaml.getAllLoaded()) {
                        utils.removeQuotesFromValues(m.getValues());
                    }
                }
                if (yaml.isRemoveLoadedNullValuesEnabled) {
                    for (YamlSection m : yaml.getAllLoaded()) {
                        utils.removeNullValues(m.getValues());
                    }
                }
                if (yaml.isTrimCommentsEnabled) {
                    for (YamlSection m : yaml.getAllLoaded()) {
                        utils.trimComments(m.getComments());
                        utils.trimComments(m.getSideComments());
                    }
                }
            }
            if (!yaml.getAllLoaded().isEmpty()) {
                for (YamlSection inEditM : yaml.getAllInEdit()) {
                    YamlSection loadedM = utils.getExisting(inEditM, yaml.getAllLoaded());
                    inEditM.setSValues(loadedM.getValues());
                    inEditM.setParentSection(loadedM.getParentSection());
                    inEditM.setChildSections(loadedM.getChildSections());
                }
            }
            timer.stop();
        }
        catch (IllegalListException | YamlReaderException | IOException e) {
            throw e;
        }
        finally {
            if (yaml.file != null || yaml.inString != null) {
                reader.close();
            }
        }
    }

    public void checkChar(DYLine line, int charCode, int charCodePos) {
        switch (charCode) {
            case 32: {
                if (line.isCharFound()) break;
                line.setCountSpaces(line.getCountSpaces() + 1);
                break;
            }
            case 35: {
                line.setCharFound(true);
                int charCodeBefore = 0;
                try {
                    charCodeBefore = line.getFullLine().codePointAt(charCodePos - 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (charCodeBefore != 0 && charCodeBefore != 32) break;
                line.setCommentFound(true);
                boolean anotherHashtagFound = false;
                for (int i = charCodePos + 1; i < line.getFullLine().length(); ++i) {
                    if (line.getFullLine().codePointAt(i) != 35) continue;
                    anotherHashtagFound = true;
                    line.setRawComment(line.getFullLine().substring(i + 1));
                    if (line.getRawValue() == null) continue;
                    if (line.isKeyFound()) {
                        line.setRawValue(line.getFullLine().substring(line.getKeyFoundPos() + 1, i));
                        continue;
                    }
                    if (!line.isHyphenFound()) continue;
                    line.setRawValue(line.getFullLine().substring(line.getHyphenFoundPos() + 1, i));
                }
                if (anotherHashtagFound) break;
                line.setRawComment(line.getFullLine().substring(charCodePos + 1));
                if (line.getRawValue() == null) break;
                if (line.isKeyFound()) {
                    line.setRawValue(line.getFullLine().substring(line.getKeyFoundPos() + 1, charCodePos));
                    break;
                }
                if (!line.isHyphenFound()) break;
                line.setRawValue(line.getFullLine().substring(line.getHyphenFoundPos() + 1, charCodePos));
                break;
            }
            case 58: {
                line.setCharFound(true);
                if (line.isKeyFound() || line.isHyphenFound()) break;
                int charCodeNext = 0;
                try {
                    charCodeNext = line.getFullLine().codePointAt(charCodePos + 1);
                }
                catch (Exception anotherHashtagFound) {
                    // empty catch block
                }
                if (charCodeNext != 32 && charCodeNext != 0) break;
                line.setKeyFound(true);
                line.setKeyFoundPos(charCodePos);
                line.setRawKey(line.getFullLine().substring(line.getCountSpaces(), charCodePos));
                line.setRawValue(this.emptyToNull(line.getFullLine().substring(charCodePos + 1)));
                break;
            }
            case 45: {
                line.setCharFound(true);
                if (line.isHyphenFound()) break;
                int charCodeBefore = 0;
                try {
                    charCodeBefore = line.getFullLine().codePointAt(charCodePos - 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (charCodeBefore != 32 && charCodeBefore != 0 || line.isKeyFound()) break;
                line.setHyphenFound(true);
                line.setHyphenFoundPos(charCodePos);
                line.setRawValue(this.emptyToNull(line.getFullLine().substring(charCodePos + 1)));
                break;
            }
            default: {
                line.setCharFound(true);
            }
        }
    }

    public void parseFirstLine(Yaml yaml, DYLine currentLine) throws IllegalListException {
        if (!currentLine.getFullLine().isEmpty()) {
            for (int i = 0; i < currentLine.getFullLine().length(); ++i) {
                int charCode = currentLine.getFullLine().codePointAt(i);
                this.checkChar(currentLine, charCode, i);
                if (currentLine.isCommentFound()) break;
            }
            YamlSection module = new YamlSection(yaml);
            if (currentLine.isCommentFound()) {
                if (currentLine.isKeyFound()) {
                    module.setKeys(currentLine.getRawKey()).setSValues(new SmartString(currentLine.getRawValue()));
                    module.addSideComments(currentLine.getRawComment());
                    yaml.getAllLoaded().add(module);
                } else {
                    if (currentLine.isHyphenFound()) {
                        throw new IllegalListException(yaml.getInputStream() == null ? yaml.getFile().getName() : "<InputStream>", currentLine);
                    }
                    module.addComments(currentLine.getRawComment());
                }
            } else if (currentLine.isKeyFound()) {
                module.setKeys(currentLine.getRawKey()).setValues(currentLine.getRawValue());
                yaml.getAllLoaded().add(module);
            } else if (currentLine.isHyphenFound()) {
                throw new IllegalListException(yaml.getInputStream() == null ? yaml.getFile().getName() : "<InputStream>", currentLine);
            }
            this.beforeModule = module;
        }
    }

    public void parseLine(Yaml yaml, DYLine currentLine) {
        int i;
        if (currentLine.getFullLine().trim().isEmpty()) {
            ++this.countEmptyBeforeLines;
            return;
        }
        List<YamlSection> allLoaded = yaml.getAllLoaded();
        YamlSection module = new YamlSection(yaml);
        String fullLine = currentLine.getFullLine();
        for (i = 0; i < fullLine.length(); ++i) {
            int charCode = fullLine.codePointAt(i);
            this.checkChar(currentLine, charCode, i);
            if (currentLine.isCommentFound()) break;
        }
        if (currentLine.isCommentFound()) {
            if (currentLine.isKeyFound()) {
                if (this.beforeLine.isCommentFound() && !this.beforeLine.isKeyFound() && !this.beforeLine.isHyphenFound()) {
                    module = this.beforeModule;
                } else {
                    module.setCountTopLineBreaks(this.countEmptyBeforeLines);
                    this.countEmptyBeforeLines = 0;
                }
                if (currentLine.getCountSpaces() > 0) {
                    for (i = this.keyLinesList.size() - 1; i >= 0; --i) {
                        DYLine oldLine = this.keyLinesList.get(i);
                        if (currentLine.getCountSpaces() - oldLine.getCountSpaces() != 2) continue;
                        YamlSection oldModule = allLoaded.get(i);
                        module.getKeys().addAll(oldModule.getKeys());
                        module.setParentSection(oldModule);
                        oldModule.addChildSections(module);
                        break;
                    }
                }
                module.addKeys(currentLine.getRawKey());
                module.setSValues(new SmartString(currentLine.getRawValue()));
                module.addSideComments(currentLine.getRawComment());
                allLoaded.add(module);
            } else if (currentLine.isHyphenFound()) {
                YamlSection oldModule = yaml.getLastLoadedModule();
                if (this.beforeLine.isCommentFound() && !this.beforeLine.isKeyFound() && !this.beforeLine.isHyphenFound()) {
                    StringBuilder c = new StringBuilder(currentLine.getRawComment());
                    for (String comment : this.beforeModule.getComments()) {
                        c.append(" # ").append(comment);
                    }
                    currentLine.setRawComment(c.toString());
                }
                if (!this.beforeLine.isHyphenFound() && oldModule.getValues().size() == 1 && oldModule.getValues().get(0).asString() == null) {
                    oldModule.getValues().remove(0);
                }
                oldModule.addValues(new SmartString(currentLine.getRawValue()));
                oldModule.addSideComments(currentLine.getRawComment());
            } else {
                if (this.beforeLine.isCommentFound() && !this.beforeLine.isKeyFound() && !this.beforeLine.isHyphenFound()) {
                    module = this.beforeModule;
                } else {
                    module.setCountTopLineBreaks(this.countEmptyBeforeLines);
                    this.countEmptyBeforeLines = 0;
                }
                module.addComments(currentLine.getRawComment());
            }
        } else if (currentLine.isKeyFound()) {
            if (this.beforeLine.isCommentFound() && !this.beforeLine.isKeyFound() && !this.beforeLine.isHyphenFound()) {
                module = this.beforeModule;
            } else {
                module.setCountTopLineBreaks(this.countEmptyBeforeLines);
                this.countEmptyBeforeLines = 0;
            }
            if (currentLine.getCountSpaces() > 0) {
                for (i = this.keyLinesList.size() - 1; i >= 0; --i) {
                    DYLine oldLine = this.keyLinesList.get(i);
                    if (currentLine.getCountSpaces() - oldLine.getCountSpaces() != 2) continue;
                    YamlSection oldModule = allLoaded.get(i);
                    module.getKeys().addAll(oldModule.getKeys());
                    module.setParentSection(oldModule);
                    oldModule.addChildSections(module);
                    break;
                }
            }
            module.addKeys(currentLine.getRawKey());
            module.setValues(currentLine.getRawValue());
            allLoaded.add(module);
        } else if (currentLine.isHyphenFound()) {
            YamlSection oldModule = yaml.getLastLoadedModule();
            if (this.beforeLine.isCommentFound() && !this.beforeLine.isKeyFound() && !this.beforeLine.isHyphenFound()) {
                StringBuilder c = new StringBuilder(currentLine.getRawComment());
                for (String comment : this.beforeModule.getComments()) {
                    c.append(" # ").append(comment);
                }
                currentLine.setRawComment(c.toString());
            }
            if (!this.beforeLine.isHyphenFound() && oldModule.getValues().size() == 1 && oldModule.getValues().get(0).asString() == null) {
                oldModule.getValues().remove(0);
            }
            oldModule.addValues(currentLine.getRawValue());
        } else {
            SmartString lastValue = yaml.getLastLoadedModule().getLastValue();
            if (lastValue.asString() == null) {
                lastValue.set(currentLine.getFullLine());
            } else {
                lastValue.set(lastValue.asString() + "\n" + currentLine.getFullLine());
            }
        }
        this.beforeModule = module;
    }

    private String emptyToNull(String s) {
        if (s.trim().isEmpty()) {
            return null;
        }
        return s;
    }
}

