/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.yml.utils;

import java.text.DecimalFormat;

public class UtilsTimeStopper {
    private final DecimalFormat df = new DecimalFormat();
    private long time1 = 0L;
    private long time2 = 0L;

    public void start() {
        this.time1 = System.nanoTime();
    }

    public void stop() {
        this.time2 = System.nanoTime();
    }

    public Double getSeconds() {
        return (double)(this.time2 - this.time1) / 1000000.0 / 1000.0;
    }

    public Double getMillis() {
        return (double)(this.time2 - this.time1) / 1000000.0;
    }

    public Double getNanos() {
        return (double)(this.time2 - this.time1) + 0.0;
    }

    public String getFormattedSeconds() {
        Double d = this.getSeconds();
        return this.df.format(d).replace(".", ",");
    }

    public String getFormattedMillis() {
        Double d = this.getMillis();
        return this.df.format(d).replace(".", ",");
    }

    public String getFormattedNanos() {
        Double d = this.getNanos();
        return this.df.format(d).replace(".", ",");
    }

    private void check() throws Exception {
        if (this.time1 == 0L || this.time2 == 0L) {
            throw new Exception("Time 1 or time 2 are null. Ensure that you have started and stopped the counter before retrieving the result!");
        }
    }
}

