/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.yml.utils;

import com.mohistmc.yml.SmartString;
import com.mohistmc.yml.YamlSection;
import java.util.ArrayList;
import java.util.List;

public class UtilsYamlSection {
    public YamlSection getAlreadyExistingModuleByKeys(YamlSection queryModule, List<YamlSection> modules) {
        int size = queryModule.getKeys().size();
        for (YamlSection listModule : modules) {
            if (size != listModule.getKeys().size()) continue;
            for (int i = 0; i < size && queryModule.getKeys().get(i).equals(listModule.getKeys().get(i)); ++i) {
                if (i != size - 1) continue;
                return listModule;
            }
        }
        return null;
    }

    public YamlSection getExisting(YamlSection queryModule, List<YamlSection> modules) {
        for (YamlSection listModule : modules) {
            if (!listModule.getKeys().equals(queryModule.getKeys())) continue;
            return listModule;
        }
        return null;
    }

    public YamlSection getExisting(List<String> keys, List<YamlSection> modules) {
        for (YamlSection listModule : modules) {
            if (!listModule.getKeys().equals(keys)) continue;
            return listModule;
        }
        return null;
    }

    public int getClosestParentIndex(List<String> keys, List<YamlSection> sections) {
        int index = -1;
        int highestCountMatchedKeys = 0;
        int currentIndex = 0;
        for (YamlSection section : sections) {
            int countMatched = 0;
            int size = Math.min(section.getKeys().size(), keys.size());
            for (int i = 0; i < size && section.getKeys().get(i).equals(keys.get(i)); ++i) {
                ++countMatched;
            }
            if (countMatched != 0 && countMatched >= highestCountMatchedKeys) {
                highestCountMatchedKeys = countMatched;
                index = currentIndex;
            }
            ++currentIndex;
        }
        return index;
    }

    public <T> List<SmartString> arrayToValuesList(T[] array) {
        ArrayList<SmartString> values = new ArrayList<SmartString>();
        for (T t : array) {
            if (t == null) {
                values.add(new SmartString(null));
                continue;
            }
            values.add(new SmartString(t.toString()));
        }
        return values;
    }

    public <T> List<SmartString> listToValuesList(List<T> list) {
        ArrayList<SmartString> values = new ArrayList<SmartString>();
        for (T t : list) {
            if (t == null) {
                values.add(new SmartString(null));
                continue;
            }
            values.add(new SmartString(t.toString()));
        }
        return values;
    }

    public List<String> valuesListToStringList(List<SmartString> list) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (SmartString value : list) {
            stringList.add(value.asString());
        }
        return stringList;
    }

    public void trimValues(List<SmartString> values) {
        ArrayList<SmartString> copy = new ArrayList<SmartString>(values);
        for (SmartString value : copy) {
            String s = value.asString();
            if (s == null) continue;
            s = s.trim();
            value.set(s);
        }
    }

    public void trimComments(List<String> comments) {
        ArrayList<String> copy = new ArrayList<String>(comments);
        for (int i = 0; i < copy.size(); ++i) {
            String c = (String)copy.get(i);
            if (c == null) continue;
            comments.set(i, ((String)copy.get(i)).trim());
        }
    }

    public void removeQuotesFromValues(List<SmartString> values) {
        ArrayList<SmartString> copy = new ArrayList<SmartString>(values);
        for (SmartString value : copy) {
            String s = value.asString();
            if (!this.isEncapsulatedInQuotes(s)) continue;
            s = s.substring(1, s.length() - 1);
            value.set(s);
        }
    }

    public boolean isEncapsulatedInQuotes(String s) {
        if (s != null) {
            char lastChar;
            if ((s = s.trim()).isEmpty()) {
                return false;
            }
            char firstChar = s.charAt(0);
            if (firstChar == (lastChar = s.charAt(s.length() - 1))) {
                return firstChar == '\"' || firstChar == '\'' || firstChar == '`';
            }
        }
        return false;
    }

    public void removeNullValues(List<SmartString> values) {
        ArrayList<SmartString> copy = new ArrayList<SmartString>(values);
        for (int i = 0; i < copy.size(); ++i) {
            if (((SmartString)copy.get(i)).asString() != null) continue;
            values.remove(i);
        }
    }
}

