/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.yml.watcher;

import com.mohistmc.yml.watcher.FileEvent;
import com.mohistmc.yml.watcher.WatchedDir;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class DirWatcher
extends Thread
implements AutoCloseable {
    public static final List<DirWatcher> activeWatchers = new ArrayList<DirWatcher>();
    public WatchedDir registeredDir;
    public WatchService watchService;
    public boolean isWatchSubDirs = false;
    public WatchKey watchKey;
    public List<Consumer<FileEvent>> listeners;
    public List<DirWatcher> subDirectoriesWatchers = new ArrayList<DirWatcher>();
    public static ExecutorService listenerExecutor = Executors.newCachedThreadPool();

    private DirWatcher(Path dirPath, boolean watchSubdirectories) throws IOException {
        this.init(dirPath, watchSubdirectories);
    }

    public static synchronized DirWatcher get(File file, boolean isWatchSubDirs) throws IOException {
        return DirWatcher.get(file.toPath(), isWatchSubDirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DirWatcher get(Path path, boolean isWatchSubDirs) throws IOException {
        if (!path.toFile().isDirectory()) {
            path = path.getParent();
        }
        List<DirWatcher> list = activeWatchers;
        synchronized (list) {
            for (DirWatcher watcher : activeWatchers) {
                if (!watcher.getRegisteredDir().toPath().equals(path) || !watcher.isAlive()) continue;
                return watcher;
            }
        }
        return new DirWatcher(path, isWatchSubDirs);
    }

    private void init(Path path, boolean watchSubdirectories) throws IOException {
        Objects.requireNonNull(path);
        this.watchService = FileSystems.getDefault().newWatchService();
        this.isWatchSubDirs = this.isWatchSubDirs();
        this.registeredDir = new WatchedDir(path.toString(), this);
        if (!path.toFile().isDirectory()) {
            this.watchDir(path.getParent(), watchSubdirectories);
        } else {
            this.watchDir(path, watchSubdirectories);
        }
        this.start();
    }

    @Override
    public void run() {
        super.run();
        try {
            WatchKey key;
            long eventId = 0L;
            while ((key = this.watchService.take()) != null) {
                this.watchKey = key;
                Thread.sleep(50L);
                for (WatchEvent<?> event : key.pollEvents()) {
                    if (this.listeners == null || ((Path)event.context()).toFile().isDirectory()) continue;
                    long finalEventId = eventId;
                    for (Consumer<FileEvent> listener : this.listeners) {
                        listenerExecutor.execute(() -> listener.accept(new FileEvent(this.registeredDir, event, finalEventId)));
                    }
                    ++eventId;
                }
                key.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("DYWatcher crashed! Please restart it to keep using its functions!");
        }
    }

    @Override
    public void close() throws Exception {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean closeSubdirectories) throws IOException {
        List<DirWatcher> list = activeWatchers;
        synchronized (list) {
            if (this.watchKey != null) {
                this.watchKey.cancel();
            }
            this.watchService.close();
            activeWatchers.remove(this);
            if (closeSubdirectories) {
                for (DirWatcher subDirWatcher : this.subDirectoriesWatchers) {
                    subDirWatcher.close(true);
                }
                this.subDirectoriesWatchers.clear();
            }
        }
    }

    private void watchDir(Path path, boolean watchSubdirectories) throws IOException {
        if (!path.toFile().exists()) {
            throw new IOException("File '" + path.getFileName() + "' does not exist! Full path: " + path);
        }
        WatchKey watchKey = path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW);
        if (watchSubdirectories) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                int pos = 0;

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                    if (this.pos != 0) {
                        DirWatcher.this.subDirectoriesWatchers.add(DirWatcher.get(path, true).addListeners(DirWatcher.this.listeners));
                    }
                    ++this.pos;
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public DirWatcher watchFile(final File file, final Consumer<FileEvent> listener) throws IOException {
        Consumer<FileEvent> actualListener = new Consumer<FileEvent>(){

            @Override
            public void accept(FileEvent event) {
                if (event.path.equals(file.toPath())) {
                    listener.accept(event);
                }
            }
        };
        this.addListeners(actualListener);
        return this;
    }

    public DirWatcher addListeners(Consumer<FileEvent> ... listeners) throws IOException {
        this.addListeners(Arrays.asList(listeners));
        return this;
    }

    public DirWatcher addListeners(List<Consumer<FileEvent>> listeners) throws IOException {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Consumer<FileEvent>>();
        }
        if (listeners != null) {
            this.listeners.addAll(listeners);
        }
        for (DirWatcher subWatcher : this.subDirectoriesWatchers) {
            subWatcher.addListeners(listeners);
        }
        return this;
    }

    public DirWatcher removeListeners(Consumer<FileEvent> ... listeners) throws Exception {
        Objects.requireNonNull(listeners);
        this.removeListeners(Arrays.asList(listeners));
        return this;
    }

    public DirWatcher removeListeners(List<Consumer<FileEvent>> listeners) throws Exception {
        this.listeners.removeAll(listeners);
        for (DirWatcher subWatcher : this.subDirectoriesWatchers) {
            subWatcher.removeListeners(listeners);
        }
        return this;
    }

    public DirWatcher removeAllListeners(boolean alsoRemoveSubDirListeners) {
        this.listeners.clear();
        if (alsoRemoveSubDirListeners) {
            for (DirWatcher subWatcher : this.subDirectoriesWatchers) {
                subWatcher.removeAllListeners(true);
            }
        }
        return this;
    }

    public boolean isWatchSubDirs() {
        return this.isWatchSubDirs;
    }

    public void setWatchSubDirs(boolean watchSubDirs) {
        this.isWatchSubDirs = watchSubDirs;
    }

    public WatchService getWatchService() {
        return this.watchService;
    }

    public void printDetails() {
        System.out.println("Watcher: " + this);
        if (this.registeredDir.isDirectory()) {
            System.out.println("Registered dir: " + this.registeredDir);
        } else {
            System.out.println("Registered file: " + this.registeredDir);
        }
    }

    public WatchedDir getRegisteredDir() {
        return this.registeredDir;
    }

    public WatchKey getWatchKey() {
        return this.watchKey;
    }

    public List<Consumer<FileEvent>> getListeners() {
        return this.listeners;
    }

    public void setListeners(Consumer<FileEvent> ... listeners) throws IOException {
        Objects.requireNonNull(listeners);
        this.setListeners(Arrays.asList(listeners));
    }

    public DirWatcher setListeners(List<Consumer<FileEvent>> listeners) throws IOException {
        this.listeners = listeners;
        for (DirWatcher watcher : this.subDirectoriesWatchers) {
            watcher.setListeners(listeners);
        }
        return this;
    }
}

