/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.action;

import com.mohistmc.MohistMCStart;
import com.mohistmc.action.Action;
import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.tools.FileUtils;
import com.mohistmc.tools.JarTool;
import com.mohistmc.tools.MD5Util;
import com.mohistmc.util.I18n;
import com.mohistmc.util.MohistModuleManager;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class v_1_20_1 {
    public static final List<String> loadedLibsPaths = new ArrayList<String>();

    public static void restartServer(List<String> cmd, boolean shutdown) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.directory(MohistMCStart.jarTool.getJarDir());
        pb.inheritIO().start().waitFor();
        Thread.sleep(2000L);
        if (shutdown) {
            System.exit(0);
        }
    }

    public static void run() {
        try {
            new Install();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Install
    extends Action {
        public static ArrayList<String> launchArgs = new ArrayList<String>(Arrays.asList("java", "-jar"));
        public final File fmlloader;
        public final File fmlcore;
        public final File javafmllanguage;
        public final File mclanguage;
        public final File lowcodelanguage;
        public final File mohistplugin;
        public final File mojmap;
        public final File mc_unpacked;
        public final File mergedMapping;

        protected Install() throws Exception {
            this.fmlloader = new File(this.libPath, "net/minecraftforge/fmlloader/" + this.mcVer + "-" + this.forgeVer + "/fmlloader-" + this.mcVer + "-" + this.forgeVer + ".jar");
            this.fmlcore = new File(this.libPath, "net/minecraftforge/fmlcore/" + this.mcVer + "-" + this.forgeVer + "/fmlcore-" + this.mcVer + "-" + this.forgeVer + ".jar");
            this.javafmllanguage = new File(this.libPath, "net/minecraftforge/javafmllanguage/" + this.mcVer + "-" + this.forgeVer + "/javafmllanguage-" + this.mcVer + "-" + this.forgeVer + ".jar");
            this.mclanguage = new File(this.libPath, "net/minecraftforge/mclanguage/" + this.mcVer + "-" + this.forgeVer + "/mclanguage-" + this.mcVer + "-" + this.forgeVer + ".jar");
            this.lowcodelanguage = new File(this.libPath, "net/minecraftforge/lowcodelanguage/" + this.mcVer + "-" + this.forgeVer + "/lowcodelanguage-" + this.mcVer + "-" + this.forgeVer + ".jar");
            this.mohistplugin = new File(this.libPath, "com/mohistmc/mohistplugins/mohistplugins-" + this.mcVer + ".jar");
            this.mojmap = new File(this.libPath, this.otherStart + "-mappings.txt");
            this.mc_unpacked = new File(this.libPath, this.otherStart + "-unpacked.jar");
            this.mergedMapping = new File(this.libPath, this.mcpStart + "-mappings-merged.txt");
            this.libPath();
            this.install();
        }

        private void install() throws Exception {
            launchArgs.add(new File(MohistModuleManager.class.getProtectionDomain().getCodeSource().getLocation().getPath().substring(1)).getName());
            launchArgs.addAll(MohistMCStart.mainArgs);
            this.copyFileFromJar(this.lzma, "data/server.lzma");
            this.copyFileFromJar(this.fmlloader, "data/fmlloader-" + this.mcVer + "-" + this.forgeVer + ".jar");
            this.copyFileFromJar(this.fmlcore, "data/fmlcore-" + this.mcVer + "-" + this.forgeVer + ".jar");
            this.copyFileFromJar(this.javafmllanguage, "data/javafmllanguage-" + this.mcVer + "-" + this.forgeVer + ".jar");
            this.copyFileFromJar(this.mclanguage, "data/mclanguage-" + this.mcVer + "-" + this.forgeVer + ".jar");
            this.copyFileFromJar(this.lowcodelanguage, "data/lowcodelanguage-" + this.mcVer + "-" + this.forgeVer + ".jar");
            this.copyFileFromJar(this.mohistplugin, "data/mohistplugins-" + this.mcVer + ".jar");
            if (!this.checkDependencies()) {
                return;
            }
            System.out.println(I18n.as("installation.start"));
            this.copyFileFromJar(this.universalJar, "data/forge-" + this.mcVer + "-" + this.forgeVer + "-universal.jar");
            if (this.mohistVer == null || this.mcpVer == null) {
                System.out.println("[Mohist] There is an error with the installation, the forge / mcp version is not set.");
                System.exit(0);
            }
            if (this.minecraft_server.exists()) {
                this.mute();
                this.run("net.minecraftforge.installertools.ConsoleTool", new String[]{"--task", "BUNDLER_EXTRACT", "--input", this.minecraft_server.getPath(), "--output", this.libPath, "--libraries"}, this.stringToUrl(loadedLibsPaths));
                this.unmute();
                if (!this.mc_unpacked.exists()) {
                    this.mute();
                    this.run("net.minecraftforge.installertools.ConsoleTool", new String[]{"--task", "BUNDLER_EXTRACT", "--input", this.minecraft_server.getPath(), "--output", this.mc_unpacked.getPath(), "--jar-only"}, this.stringToUrl(loadedLibsPaths));
                    this.unmute();
                }
            } else {
                System.out.println(I18n.as("installation.minecraftserver"));
            }
            if (this.mcpZip.exists()) {
                if (!this.mcpTxt.exists()) {
                    System.out.println(I18n.as("installation.mcp"));
                    this.mute();
                    this.run("net.minecraftforge.installertools.ConsoleTool", new String[]{"--task", "MCP_DATA", "--input", this.mcpZip.getPath(), "--output", this.mcpTxt.getPath(), "--key", "mappings"}, this.stringToUrl(loadedLibsPaths));
                    this.unmute();
                }
            } else {
                System.out.println(I18n.as("installation.mcpfilemissing"));
                System.exit(0);
            }
            if (JarTool.isCorrupted(this.extra)) {
                this.extra.delete();
            }
            if (JarTool.isCorrupted(this.slim)) {
                this.slim.delete();
            }
            if (JarTool.isCorrupted(this.srg)) {
                this.srg.delete();
            }
            if (!this.mergedMapping.exists()) {
                this.mute();
                this.run("net.minecraftforge.installertools.ConsoleTool", new String[]{"--task", "MERGE_MAPPING", "--left", this.mcpTxt.getPath(), "--right", this.mojmap.getPath(), "--output", this.mergedMapping.getAbsolutePath(), "--classes", "--reverse-right"}, this.stringToUrl(loadedLibsPaths));
                this.unmute();
            }
            if (!this.slim.exists() || !this.extra.exists()) {
                this.mute();
                this.run("net.minecraftforge.jarsplitter.ConsoleTool", new String[]{"--input", this.minecraft_server.getPath(), "--slim", this.slim.getPath(), "--extra", this.extra.getPath(), "--srg", this.mergedMapping.getAbsolutePath()}, this.stringToUrl(loadedLibsPaths));
                this.run("net.minecraftforge.jarsplitter.ConsoleTool", new String[]{"--input", this.mc_unpacked.getPath(), "--slim", this.slim.getPath(), "--extra", this.extra.getPath(), "--srg", this.mergedMapping.getAbsolutePath()}, this.stringToUrl(loadedLibsPaths));
                this.unmute();
            }
            if (!this.srg.exists()) {
                this.mute();
                this.run("net.minecraftforge.fart.Main", new String[]{"--input", this.slim.getPath(), "--output", this.srg.getPath(), "--names", this.mergedMapping.getPath(), "--ann-fix", "--ids-fix", "--src-fix", "--record-fix"}, this.stringToUrl(loadedLibsPaths));
                this.unmute();
            }
            String storedServerMD5 = null;
            String storedMohistMD5 = null;
            String serverMD5 = MD5Util.get(this.serverJar);
            String mohistMD5 = MD5Util.get(MohistMCStart.jarTool.getFile());
            if (this.installInfo.exists()) {
                List<String> infoLines = Files.readAllLines(this.installInfo.toPath());
                if (!infoLines.isEmpty()) {
                    storedServerMD5 = infoLines.get(0);
                }
                if (infoLines.size() > 1) {
                    storedMohistMD5 = infoLines.get(1);
                }
            }
            if (!(this.serverJar.exists() && storedServerMD5 != null && storedMohistMD5 != null && storedServerMD5.equals(serverMD5) && storedMohistMD5.equals(mohistMD5))) {
                this.mute();
                this.run("net.minecraftforge.binarypatcher.ConsoleTool", new String[]{"--clean", this.srg.getPath(), "--output", this.serverJar.getPath(), "--apply", this.lzma.getPath()}, this.stringToUrl(loadedLibsPaths));
                this.unmute();
                serverMD5 = MD5Util.get(this.serverJar);
            }
            FileWriter fw = new FileWriter(this.installInfo);
            fw.write(serverMD5 + "\n");
            fw.write(mohistMD5);
            fw.close();
            System.out.println(I18n.as("installation.finished"));
            MohistConfigUtil.INSTALLATIONFINISHED.setValues(true);
            MohistConfigUtil.save();
            v_1_20_1.restartServer(launchArgs, true);
        }

        protected void libPath() throws Exception {
            File out = new File(this.libPath, "com/mohistmc/cache/libPath.txt");
            if (!out.exists()) {
                out.getParentFile().mkdirs();
                out.createNewFile();
            }
            FileUtils.fileWriterMethod(out.getPath(), this.libPath);
        }
    }
}

