/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.yml.db;

import com.mohistmc.yml.SmartString;
import com.mohistmc.yml.YamlSection;
import com.mohistmc.yml.db.YamlColumn;
import com.mohistmc.yml.db.YamlRow;
import com.mohistmc.yml.exceptions.BrokenColumnsException;
import com.mohistmc.yml.exceptions.DuplicateKeyException;
import com.mohistmc.yml.exceptions.IllegalKeyException;
import com.mohistmc.yml.exceptions.IllegalListException;
import com.mohistmc.yml.exceptions.NotLoadedException;
import com.mohistmc.yml.exceptions.YamlReaderException;
import com.mohistmc.yml.exceptions.YamlWriterException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public record YamlTable(YamlSection tableModule) {
    public YamlTable {
        Objects.requireNonNull(tableModule);
    }

    public String getName() {
        return this.tableModule.getLastKey();
    }

    public YamlRow getRow(int index) {
        HashMap<SmartString, YamlColumn> valuesAndColumns = new HashMap<SmartString, YamlColumn>();
        for (YamlColumn col : this.getColumns()) {
            valuesAndColumns.put(col.get(index), col);
        }
        return new YamlRow(index, valuesAndColumns);
    }

    public List<SmartString> getRowAsList(int index) {
        ArrayList<SmartString> row = new ArrayList<SmartString>();
        for (YamlColumn col : this.getColumns()) {
            row.add(col.get(index));
        }
        return row;
    }

    public YamlTable addRow(String ... values) {
        List<YamlColumn> columns = this.getColumns();
        ArrayList<YamlColumn> columnsCopy = new ArrayList<YamlColumn>(columns);
        for (YamlColumn col : columns) {
            for (YamlColumn col1 : columnsCopy) {
                if (col.equals(col1) || col.size() == col1.size()) continue;
                throw new BrokenColumnsException("All columns should have the same length. Column '" + col.getName() + "' has a size of '" + col.size() + "' but column " + col1.getName() + " has a size of '" + col1.size() + "'.");
            }
        }
        if (values.length > columns.size()) {
            throw new IndexOutOfBoundsException("Failed to addRow(), because there are more values(" + values.length + ") than columns(" + columns.size() + ") available!");
        }
        for (int i = 0; i < columns.size(); ++i) {
            String val = null;
            try {
                val = values[i];
            }
            catch (Exception exception) {
                // empty catch block
            }
            columns.get(i).add(val);
        }
        return this;
    }

    public YamlTable addDefRow(String ... values) {
        int i;
        List<YamlColumn> allColumns = this.getColumns();
        ArrayList<YamlColumn> columnsCopy = new ArrayList<YamlColumn>(allColumns);
        for (YamlColumn col : allColumns) {
            for (YamlColumn col1 : columnsCopy) {
                if (col.equals(col1) || col.size() == col1.size()) continue;
                throw new BrokenColumnsException("All columns should have the same size/length. Column '" + col.getName() + "' has a size of '" + col.size() + "' but column '" + col1.getName() + "' has a size of '" + col1.size() + "'.");
            }
        }
        if (values.length > allColumns.size()) {
            throw new IndexOutOfBoundsException("Failed to addDefRow(), because there are more values(" + values.length + ") than columns(" + allColumns.size() + ") available!");
        }
        for (i = 0; i < values.length; ++i) {
            allColumns.get(i).addDef(values[i]);
            System.out.println("ADDED");
        }
        for (i = values.length - 1; i < allColumns.size() - values.length; ++i) {
            allColumns.get(i).addDef(new String[]{null});
        }
        return this;
    }

    public YamlTable setRow(int index, SmartString ... values) {
        int i;
        List<YamlColumn> columns = this.getColumns();
        for (YamlColumn col : columns) {
            try {
                col.get(index);
            }
            catch (Exception e) {
                throw new IndexOutOfBoundsException("Row '" + index + "' does not exist for column '" + col.getName() + "' in table '" + this.getName() + "'.");
            }
        }
        for (i = 0; i < values.length; ++i) {
            columns.get(i).get(index).set(values[i].asString());
        }
        for (i = values.length - 1; i < columns.size() - values.length; ++i) {
            columns.get(i).get(index).set((String)null);
        }
        return this;
    }

    public YamlColumn addColumn(String name) throws NotLoadedException, IllegalKeyException, DuplicateKeyException, YamlWriterException, IOException, YamlReaderException, IllegalListException {
        YamlColumn column = new YamlColumn(this.tableModule.getYaml().add("tables", this.getName(), name));
        this.tableModule.getYaml().saveAndLoad();
        return column;
    }

    public YamlColumn putColumn(String name) throws NotLoadedException, IllegalKeyException, YamlWriterException, IOException, DuplicateKeyException, YamlReaderException, IllegalListException {
        YamlColumn column = new YamlColumn(this.tableModule.getYaml().put("tables", this.getName(), name));
        this.tableModule.getYaml().saveAndLoad();
        return column;
    }

    public YamlTable removeColumn(YamlColumn column) throws YamlWriterException, IOException, DuplicateKeyException, YamlReaderException, IllegalListException {
        Objects.requireNonNull(column);
        this.tableModule.getYaml().remove("tables", this.getName(), column.getName());
        this.tableModule.getYaml().saveAndLoad();
        return this;
    }

    public YamlColumn getColumn(String name) {
        for (YamlColumn c : this.getColumns()) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public YamlColumn getColumnAtIndex(int index) {
        return this.getColumns().get(index);
    }

    public List<YamlColumn> getColumns() {
        ArrayList<YamlColumn> columns = new ArrayList<YamlColumn>();
        for (YamlSection columnModule : this.tableModule.getChildSections()) {
            columns.add(new YamlColumn(this.tableModule.getYaml().get(columnModule.getKeys())));
        }
        return columns;
    }

    public List<YamlRow> getValuesEqualTo(String colName, String value) {
        YamlColumn column = this.getColumn(colName);
        Objects.requireNonNull(column);
        return this.getValuesEqualTo(column, value);
    }

    public List<YamlRow> getValuesEqualTo(YamlColumn column, String value) {
        ArrayList<YamlRow> results = new ArrayList<YamlRow>();
        int index = 0;
        for (SmartString v : column.getValues()) {
            if (v.asString() != null && v.asString().equals(value)) {
                HashMap<SmartString, YamlColumn> map = new HashMap<SmartString, YamlColumn>();
                for (YamlColumn col : this.getColumns()) {
                    map.put(col.get(index), col);
                }
                results.add(new YamlRow(index, map));
            }
            ++index;
        }
        return results;
    }

    public List<YamlRow> getValuesBiggerThan(YamlColumn column, long value) {
        ArrayList<YamlRow> results = new ArrayList<YamlRow>();
        int index = 0;
        for (SmartString v : column.getValues()) {
            if (v.asLong() > value) {
                HashMap<SmartString, YamlColumn> map = new HashMap<SmartString, YamlColumn>();
                for (YamlColumn col : this.getColumns()) {
                    map.put(col.get(index), col);
                }
                results.add(new YamlRow(index, map));
            }
            ++index;
        }
        return results;
    }

    public List<YamlRow> getValuesBiggerThan(YamlColumn column, double value) {
        ArrayList<YamlRow> results = new ArrayList<YamlRow>();
        int index = 0;
        for (SmartString v : column.getValues()) {
            if (v.asDouble() > value) {
                HashMap<SmartString, YamlColumn> map = new HashMap<SmartString, YamlColumn>();
                for (YamlColumn col : this.getColumns()) {
                    map.put(col.get(index), col);
                }
                results.add(new YamlRow(index, map));
            }
            ++index;
        }
        return results;
    }

    public List<YamlRow> getValuesSmallerThan(YamlColumn column, long value) {
        ArrayList<YamlRow> results = new ArrayList<YamlRow>();
        int index = 0;
        for (SmartString v : column.getValues()) {
            if (v.asLong() < value) {
                HashMap<SmartString, YamlColumn> map = new HashMap<SmartString, YamlColumn>();
                for (YamlColumn col : this.getColumns()) {
                    map.put(col.get(index), col);
                }
                results.add(new YamlRow(index, map));
            }
            ++index;
        }
        return results;
    }

    public List<YamlRow> getValuesSmallerThan(YamlColumn column, double value) {
        ArrayList<YamlRow> results = new ArrayList<YamlRow>();
        int index = 0;
        for (SmartString v : column.getValues()) {
            if (v.asDouble() < value) {
                HashMap<SmartString, YamlColumn> map = new HashMap<SmartString, YamlColumn>();
                for (YamlColumn col : this.getColumns()) {
                    map.put(col.get(index), col);
                }
                results.add(new YamlRow(index, map));
            }
            ++index;
        }
        return results;
    }
}

