/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.yml.utils;

import com.mohistmc.yml.Yaml;
import com.mohistmc.yml.YamlSection;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.List;

public class UtilsYaml {
    private static final String n = System.lineSeparator();
    private final Yaml yaml;

    public UtilsYaml(Yaml yaml) {
        this.yaml = yaml;
    }

    public void printLoaded(PrintStream out) {
        out.println(this.getLoadedModulesInformationAsString());
    }

    public void printInEdit(PrintStream out) {
        out.println(this.getInEditModulesInformationAsString());
    }

    public void printUnified(PrintStream out) {
        out.println(this.getUnifiedModulesInformationAsString());
    }

    public void writeLoaded(OutputStream out) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));){
            writer.write(this.getLoadedModulesInformationAsString() + n);
        }
    }

    public void writeInEdit(OutputStream out) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));){
            writer.write(this.getInEditModulesInformationAsString() + n);
        }
    }

    public void writeUnified(OutputStream out) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));){
            writer.write(this.getUnifiedModulesInformationAsString() + n);
        }
    }

    public String getLoadedModulesInformationAsString() {
        return "LOADED modules from '" + this.yaml.getSource() + "' file:" + n + this.getModulesInformationFromListAsString(this.yaml.getAllLoaded());
    }

    public String getInEditModulesInformationAsString() {
        return "ADDED modules from '" + this.yaml.getSource() + "':" + n + this.getModulesInformationFromListAsString(this.yaml.getAllInEdit());
    }

    public String getUnifiedModulesInformationAsString() {
        return "UNIFIED modules from '" + this.yaml.getSource() + "':" + n + this.getModulesInformationFromListAsString(this.yaml.createUnifiedList(this.yaml.getAllInEdit(), this.yaml.getAllLoaded()));
    }

    public String getModulesInformationFromListAsString(List<YamlSection> modules) {
        StringBuilder s = new StringBuilder();
        for (YamlSection module : modules) {
            s.append(module.toPrintString()).append(n);
        }
        return s.toString();
    }
}

