/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar.wrapped;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import me.tongfei.progressbar.ProgressBar;

public class ProgressBarWrappedOutputStream
extends FilterOutputStream {
    private ProgressBar pb;

    public ProgressBarWrappedOutputStream(OutputStream out, ProgressBar pb) {
        super(out);
        this.pb = pb;
    }

    public ProgressBar getProgressBar() {
        return this.pb;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.pb.step();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b, 0, b.length);
        this.pb.stepBy(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.pb.stepBy(len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
        this.pb.refresh();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.pb.close();
    }
}

