/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.action;

import com.mohistmc.MohistMCStart;
import com.mohistmc.tools.FileUtils;
import com.mohistmc.tools.MD5Util;
import com.mohistmc.util.DataParser;
import com.mohistmc.util.JarLoader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;

public abstract class Action {
    private static final PrintStream origin = System.out;
    public final String mohistVer = DataParser.versionMap.get("mohist");
    public final String forgeVer = DataParser.versionMap.get("forge");
    public final String mcpVer = DataParser.versionMap.get("mcp");
    public final String mcVer = DataParser.versionMap.get("minecraft");
    public final String forgeStart = "net/minecraftforge/forge/" + this.mcVer + "-" + this.forgeVer + "/forge-" + this.mcVer + "-" + this.forgeVer;
    public final File universalJar = new File(this.libPath, this.forgeStart + "-universal.jar");
    public final File serverJar = new File(this.libPath, this.forgeStart + "-server.jar");
    public final File lzma = new File(this.libPath, "com/mohistmc/installation/data/server.lzma");
    public final File installInfo = new File(this.libPath, "com/mohistmc/installation/installInfo");
    public final String otherStart = "net/minecraft/server/" + this.mcVer + "-" + this.mcpVer + "/server-" + this.mcVer + "-" + this.mcpVer;
    public final File extra = new File(this.libPath, this.otherStart + "-extra.jar");
    public final File slim = new File(this.libPath, this.otherStart + "-slim.jar");
    public final File srg = new File(this.libPath, this.otherStart + "-srg.jar");
    public final String mcpStart = "de/oceanlabs/mcp/mcp_config/" + this.mcVer + "-" + this.mcpVer + "/mcp_config-" + this.mcVer + "-" + this.mcpVer;
    public final File mcpZip = new File(this.libPath, this.mcpStart + ".zip");
    public final File mcpTxt = new File(this.libPath, this.mcpStart + "-mappings.txt");
    public final File minecraft_server = new File(this.libPath, "net/minecraft/server/" + this.mcVer + "/server-" + this.mcVer + ".jar");
    public String libPath = "libraries";

    protected Action() {
    }

    protected void run(String mainClass, String[] args, List<URL> classPath) throws Exception {
        try {
            Class.forName(mainClass);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found: " + e.getMessage());
            return;
        }
        URLClassLoader loader = URLClassLoader.newInstance(classPath.toArray(new URL[0]));
        Class.forName(mainClass, true, loader).getDeclaredMethod("main", String[].class).invoke(null, new Object[]{args});
        loader.clearAssertionStatus();
        loader.close();
    }

    protected List<URL> stringToUrl(List<String> strs) throws Exception {
        ArrayList<URL> temp = new ArrayList<URL>();
        for (String t : strs) {
            File file = t.startsWith(this.libPath) ? new File(t) : new File(this.libPath, t);
            JarLoader.loadJar(file.toPath());
            temp.add(file.toURI().toURL());
        }
        return temp;
    }

    protected void mute() throws Exception {
        File out = new File(this.libPath, "com/mohistmc/installation/installationLogs.txt");
        if (!out.exists()) {
            out.getParentFile().mkdirs();
            out.createNewFile();
        }
        System.setOut(new PrintStream(new BufferedOutputStream(new FileOutputStream(out))));
    }

    protected void unmute() {
        System.setOut(origin);
    }

    protected void copyFileFromJar(File file, String pathInJar) {
        InputStream is = MohistMCStart.class.getClassLoader().getResourceAsStream(pathInJar);
        if (!file.exists() || !MD5Util.get(file).equals(MD5Util.get(is)) || file.length() <= 1L) {
            File parentfile = file.getParentFile();
            if (file.getPath().contains("minecraftforge")) {
                int lastSlashIndex = parentfile.getPath().replaceAll("\\\\", "/").lastIndexOf("/");
                String result = parentfile.getPath().substring(0, lastSlashIndex + 1);
                File old = new File(result);
                if (old.exists()) {
                    FileUtils.deleteFolders(old);
                }
            }
            file.getParentFile().mkdirs();
            if (is != null) {
                try {
                    file.createNewFile();
                    Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {}
            } else {
                System.out.println("[Mohist] The file " + file.getName() + " doesn't exists in the Mohist jar !");
                System.exit(0);
            }
        }
    }

    public boolean checkDependencies() throws IOException {
        if (this.installInfo.exists()) {
            String jarmd = MD5Util.get(MohistMCStart.jarTool.getFile());
            List<String> lines = Files.readAllLines(this.installInfo.toPath());
            return lines.size() < 2 || !jarmd.equals(lines.get(1));
        }
        return true;
    }
}

