/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.yml;

import com.mohistmc.yml.SmartString;
import com.mohistmc.yml.Yaml;
import com.mohistmc.yml.YamlSection;
import com.mohistmc.yml.exceptions.YamlWriterException;
import com.mohistmc.yml.utils.BufferedSBWriter;
import com.mohistmc.yml.utils.UtilsTimeStopper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;

class YamlWriter {
    private Yaml yaml;

    YamlWriter() {
    }

    public void parse(Yaml yaml, boolean overwrite, boolean reset) throws YamlWriterException, IOException {
        this.yaml = yaml;
        UtilsTimeStopper timer = new UtilsTimeStopper();
        timer.start();
        BufferedWriter writer = null;
        if (yaml.outputStream != null) {
            writer = new BufferedWriter(new OutputStreamWriter(yaml.outputStream, Yaml.charset), 32768);
        } else if (yaml.file != null) {
            if (!yaml.file.exists()) {
                throw new YamlWriterException("File '" + yaml.file.getName() + "' doesn't exist!");
            }
            writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(yaml.file.toPath(), new OpenOption[0]), Yaml.charset), 32768);
        } else if (yaml.outString != null) {
            writer = new BufferedSBWriter();
        }
        if (writer == null) {
            return;
        }
        try {
            writer.write("");
            if (reset) {
                return;
            }
            List<YamlSection> sectionsToSave = overwrite ? yaml.getAllInEdit() : yaml.createUnifiedList(yaml.getAllInEdit(), yaml.getAllLoaded());
            YamlSection lastSection = new YamlSection(yaml);
            for (YamlSection m : sectionsToSave) {
                this.parseSection(writer, m, lastSection);
                lastSection = m;
            }
            timer.stop();
            if (writer instanceof BufferedSBWriter) {
                yaml.outString = ((BufferedSBWriter)writer).builder.toString();
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (yaml.file != null || yaml.outString != null) {
                writer.close();
            }
        }
    }

    private void parseSection(BufferedWriter writer, YamlSection section, YamlSection beforeModule) throws IOException {
        int keysSize = section.getKeys().size();
        int beforeKeysSize = beforeModule.getKeys().size();
        for (int i = 0; i < keysSize; ++i) {
            int j;
            String currentBeforeKey;
            String currentKey = section.getKeyAt(i);
            if (currentKey.equals(currentBeforeKey = i < beforeKeysSize && !beforeModule.getKeys().isEmpty() ? beforeModule.getKeyAt(i) : "") && (i == 0 || section.getKeyAt(i - 1).equals(beforeModule.getKeyAt(i - 1)))) continue;
            StringBuilder spaces = new StringBuilder();
            spaces.append("  ".repeat(i));
            if (i == keysSize - 1) {
                for (j = 0; j < section.getCountTopLineBreaks(); ++j) {
                    writer.newLine();
                    writer.flush();
                }
                if (section.getComments() != null) {
                    if (!section.getComments().isEmpty()) {
                        for (String comment : section.getComments()) {
                            bufReader = new BufferedReader(new StringReader(comment));
                            isMultiline = false;
                            while ((commentLine = bufReader.readLine()) != null) {
                                isMultiline = true;
                                writer.write(spaces + "# " + commentLine);
                                writer.newLine();
                                writer.flush();
                            }
                            if (isMultiline) continue;
                            writer.write(spaces + "# " + comment);
                            writer.newLine();
                            writer.flush();
                        }
                    } else if (this.yaml.isWriteDefaultCommentsWhenEmptyEnabled) {
                        for (String comment : section.getComments()) {
                            bufReader = new BufferedReader(new StringReader(comment));
                            isMultiline = false;
                            while ((commentLine = bufReader.readLine()) != null) {
                                isMultiline = true;
                                writer.write(spaces + "# " + commentLine);
                                writer.newLine();
                                writer.flush();
                            }
                            if (isMultiline) continue;
                            writer.write(spaces + "# " + comment);
                            writer.newLine();
                            writer.flush();
                        }
                    }
                }
            }
            writer.write(spaces + currentKey + ": ");
            if (section.getValues() != null && i == keysSize - 1) {
                SmartString value;
                if (!section.getValues().isEmpty() && !this.isOnlyNullsList(section.getValues())) {
                    if (section.getValues().size() == 1) {
                        SmartString value2 = section.getValue();
                        if (value2 != null && value2.asString() != null) {
                            writer.write(value2.asOutputString());
                        }
                        if (this.hasSideComment(section.getSideComments(), 0)) {
                            writer.write(" # " + section.getSideComment());
                        }
                        writer.newLine();
                        writer.flush();
                        continue;
                    }
                    writer.newLine();
                    for (j = 0; j < section.getValues().size(); ++j) {
                        value = section.getValueAt(j);
                        if (value != null) {
                            writer.write(spaces + "  - ");
                            if (value.asString() != null) {
                                writer.write(value.asOutputString());
                            }
                        }
                        if (this.hasSideComment(section.getSideComments(), j)) {
                            writer.write(" # " + section.getSideCommentAt(j));
                        }
                        writer.newLine();
                        writer.flush();
                    }
                    continue;
                }
                if (!this.yaml.isWriteDefaultValuesWhenEmptyEnabled) continue;
                if (section.getDefValues() != null && !section.getDefValues().isEmpty()) {
                    if (section.getDefValues().size() == 1) {
                        SmartString defValue = section.getDefValue();
                        if (defValue != null && defValue.asString() != null) {
                            writer.write(defValue.asOutputString());
                        }
                        if (this.hasSideComment(section.getDefSideComments(), 0)) {
                            writer.write(" # " + section.getDefSideComment());
                        }
                        writer.newLine();
                        writer.flush();
                        continue;
                    }
                    writer.newLine();
                    for (j = 0; j < section.getDefValues().size(); ++j) {
                        value = section.getDefValueAt(j);
                        if (value != null) {
                            writer.write(spaces + "  - ");
                            if (value.asString() != null) {
                                writer.write(value.asOutputString());
                            }
                        }
                        if (this.hasSideComment(section.getDefSideComments(), j)) {
                            writer.write(" # " + section.getDefSideCommentAt(j));
                        }
                        writer.newLine();
                        writer.flush();
                    }
                    continue;
                }
                writer.newLine();
                writer.flush();
                continue;
            }
            writer.newLine();
            writer.flush();
        }
    }

    private boolean hasSideComment(List<String> comments, int i) {
        try {
            if (comments.isEmpty()) {
                return false;
            }
            comments.get(i);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isOnlyNullsList(List<SmartString> values) {
        boolean hasValue = false;
        for (SmartString val : values) {
            if (val.asString() == null) continue;
            hasValue = true;
            break;
        }
        return !hasValue;
    }
}

