/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.yml.watcher;

import com.mohistmc.yml.watcher.WatchedDir;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.Objects;

public class FileEvent {
    public final WatchedDir parentDirectory;
    public final WatchEvent<?> watchEvent;
    public final File file;
    public final Path path;
    public final long id;

    public FileEvent(WatchedDir parentDirectory, WatchEvent<?> watchEvent, long id) {
        this.parentDirectory = parentDirectory;
        this.watchEvent = watchEvent;
        this.file = new File(parentDirectory + "/" + watchEvent.context());
        this.path = this.file.toPath();
        this.id = id;
    }

    public boolean isModifyEvent() {
        return Objects.equals(StandardWatchEventKinds.ENTRY_MODIFY, this.getWatchEventKind());
    }

    public boolean isCreateEvent() {
        return Objects.equals(StandardWatchEventKinds.ENTRY_CREATE, this.getWatchEventKind());
    }

    public boolean isDeleteEvent() {
        return Objects.equals(StandardWatchEventKinds.ENTRY_DELETE, this.getWatchEventKind());
    }

    public boolean isOverflowEvent() {
        return Objects.equals(StandardWatchEventKinds.ENTRY_DELETE, this.getWatchEventKind());
    }

    public WatchEvent.Kind<?> getWatchEventKind() {
        return this.watchEvent.kind();
    }

    public Object getWatchEventContext() {
        return this.watchEvent.context();
    }

    public int getWatchEventCount() {
        return this.watchEvent.count();
    }
}

