/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.mjson;

import com.mohistmc.mjson.Json;
import com.mohistmc.mjson.ObjectJson;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ArrayJson
extends Json {
    List<Json> L = new ArrayList<Json>();

    ArrayJson() {
    }

    ArrayJson(Json e) {
        super(e);
    }

    @Override
    public Json dup() {
        ArrayJson j = new ArrayJson();
        for (Json e : this.L) {
            Json v = e.dup();
            v.enclosing = j;
            j.L.add(v);
        }
        return j;
    }

    @Override
    public Json set(int index, Object value) {
        Json jvalue = ArrayJson.make(value);
        this.L.set(index, jvalue);
        ArrayJson.setParent(jvalue, this);
        return this;
    }

    @Override
    public List<Json> asJsonList() {
        return this.L;
    }

    @Override
    public List<Object> asList() {
        ArrayList<Object> A = new ArrayList<Object>();
        for (Json x : this.L) {
            A.add(x.getValue());
        }
        return A;
    }

    @Override
    public boolean is(int index, Object value) {
        if (index < 0 || index >= this.L.size()) {
            return false;
        }
        return this.L.get(index).equals(ArrayJson.make(value));
    }

    @Override
    public Object getValue() {
        return this.asList();
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public Json at(int index) {
        return this.L.get(index);
    }

    @Override
    public Json add(Json el) {
        this.L.add(el);
        ArrayJson.setParent(el, this);
        return this;
    }

    @Override
    public Json remove(Json el) {
        this.L.remove(el);
        el.enclosing = null;
        return this;
    }

    boolean isEqualJson(Json left, Json right) {
        if (left == null) {
            return right == null;
        }
        return left.equals(right);
    }

    boolean isEqualJson(Json left, Json right, Json fields) {
        if (fields.isNull()) {
            return left.equals(right);
        }
        if (fields.isString()) {
            return this.isEqualJson(ArrayJson.resolvePointer(fields.asString(), left), ArrayJson.resolvePointer(fields.asString(), right));
        }
        if (fields.isArray()) {
            for (Json field : fields.asJsonList()) {
                if (this.isEqualJson(ArrayJson.resolvePointer(field.asString(), left), ArrayJson.resolvePointer(field.asString(), right))) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Compare by options should be either a property name or an array of property names: " + fields);
    }

    int compareJson(Json left, Json right, Json fields) {
        if (fields.isNull()) {
            return ((Comparable)left.getValue()).compareTo(right.getValue());
        }
        if (fields.isString()) {
            Json leftProperty = ArrayJson.resolvePointer(fields.asString(), left);
            Json rightProperty = ArrayJson.resolvePointer(fields.asString(), right);
            return ((Comparable)((Object)leftProperty)).compareTo(rightProperty);
        }
        if (fields.isArray()) {
            for (Json field : fields.asJsonList()) {
                Json rightProperty;
                Json leftProperty = ArrayJson.resolvePointer(field.asString(), left);
                int result = ((Comparable)((Object)leftProperty)).compareTo(rightProperty = ArrayJson.resolvePointer(field.asString(), right));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
        throw new IllegalArgumentException("Compare by options should be either a property name or an array of property names: " + fields);
    }

    Json withOptions(Json array, Json allOptions, String path) {
        Json opts = allOptions.at(path, ArrayJson.object());
        boolean dup = opts.is("dup", (Object)true);
        Json compareBy = opts.at("compareBy", ArrayJson.nil());
        if (opts.is("sort", (Object)true)) {
            int thisIndex = 0;
            int thatIndex = 0;
            while (thatIndex < array.asJsonList().size()) {
                Json thatElement = array.at(thatIndex);
                if (thisIndex == this.L.size()) {
                    this.L.add(dup ? thatElement.dup() : thatElement);
                    ++thisIndex;
                    ++thatIndex;
                    continue;
                }
                int compared = this.compareJson(this.at(thisIndex), thatElement, compareBy);
                if (compared < 0) {
                    ++thisIndex;
                    continue;
                }
                if (compared > 0) {
                    this.L.add(thisIndex, dup ? thatElement.dup() : thatElement);
                    ++thatIndex;
                    continue;
                }
                ++thatIndex;
            }
        } else {
            for (Json thatElement : array.asJsonList()) {
                boolean present = false;
                for (Json thisElement : this.L) {
                    if (!this.isEqualJson(thisElement, thatElement, compareBy)) continue;
                    present = true;
                    break;
                }
                if (present) continue;
                this.L.add(dup ? thatElement.dup() : thatElement);
            }
        }
        return this;
    }

    @Override
    public Json with(Json object, Json ... options) {
        if (object == null) {
            return this;
        }
        if (!object.isArray()) {
            this.add(object);
        } else {
            if (options.length > 0) {
                Json O = this.collectWithOptions(options);
                return this.withOptions(object, O, "");
            }
            this.L.addAll(((ArrayJson)object).L);
        }
        return this;
    }

    @Override
    public Json atDel(int index) {
        Json el = this.L.remove(index);
        if (el != null) {
            el.enclosing = null;
        }
        return el;
    }

    @Override
    public Json delAt(int index) {
        Json el = this.L.remove(index);
        if (el != null) {
            el.enclosing = null;
        }
        return this;
    }

    public String toString() {
        return this.toString(Integer.MAX_VALUE);
    }

    @Override
    public String toString(int maxCharacters) {
        return this.toStringImpl(maxCharacters, new IdentityHashMap<Json, Json>());
    }

    String toStringImpl(int maxCharacters, Map<Json, Json> done) {
        StringBuilder sb = new StringBuilder("[");
        Iterator<Json> i = this.L.iterator();
        while (i.hasNext()) {
            String s;
            Json value = i.next();
            String string = value.isObject() ? ((ObjectJson)value).toStringImpl(maxCharacters, done) : (s = value.isArray() ? ((ArrayJson)value).toStringImpl(maxCharacters, done) : value.toString(maxCharacters));
            if (sb.length() + s.length() > maxCharacters) {
                s = s.substring(0, Math.max(0, maxCharacters - sb.length()));
            } else {
                sb.append(s);
            }
            if (i.hasNext()) {
                sb.append(",");
            }
            if (sb.length() < maxCharacters) continue;
            sb.append("...");
            break;
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        return this.L.hashCode();
    }

    public boolean equals(Object x) {
        return x instanceof ArrayJson && ((ArrayJson)x).L.equals(this.L);
    }
}

