/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.mjson;

import com.mohistmc.mjson.ArrayJson;
import com.mohistmc.mjson.BeanSerializer;
import com.mohistmc.mjson.JSONSerializer;
import com.mohistmc.mjson.Json;
import java.nio.charset.StandardCharsets;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ObjectJson
extends Json {
    Map<String, Json> object = new LinkedHashMap<String, Json>();

    ObjectJson() {
    }

    ObjectJson(Json e) {
        super(e);
    }

    @Override
    public Json dup() {
        ObjectJson j = new ObjectJson();
        for (Map.Entry<String, Json> e : this.object.entrySet()) {
            Json v = e.getValue().dup();
            v.enclosing = j;
            j.object.put(e.getKey(), v);
        }
        return j;
    }

    @Override
    public boolean has(String property) {
        return this.object.containsKey(property);
    }

    @Override
    public boolean is(String property, Object value) {
        Json p = this.object.get(property);
        if (p == null) {
            return false;
        }
        return p.equals(ObjectJson.make(value));
    }

    @Override
    public Json at(String property) {
        return this.object.get(property);
    }

    @Override
    public boolean asBoolean(String property) {
        return this.at(property).asBoolean();
    }

    @Override
    public String asString(String property) {
        return this.at(property).asString();
    }

    @Override
    public int asInteger(String property) {
        return this.at(property).asInteger();
    }

    @Override
    public float asFloat(String property) {
        return this.at(property).asFloat();
    }

    @Override
    public double asDouble(String property) {
        return this.at(property).asDouble();
    }

    @Override
    public long asLong(String property) {
        return this.at(property).asLong();
    }

    @Override
    public short asShort(String property) {
        return this.at(property).asShort();
    }

    @Override
    public byte asByte(String property) {
        return this.at(property).asByte();
    }

    @Override
    public char asChar(String property) {
        return this.at(property).asChar();
    }

    @Override
    public Map<String, Object> asMap(String property) {
        return this.at(property).asMap();
    }

    @Override
    public Map<String, Json> asJsonMap(String property) {
        return this.at(property).asJsonMap();
    }

    @Override
    public List<Object> asList(String property) {
        return this.at(property).asList();
    }

    @Override
    public List<Json> asJsonList(String property) {
        return this.at(property).asJsonList();
    }

    @Override
    public <T> T asBean(Class<T> classZ) {
        return BeanSerializer.deserialize(classZ, JSONSerializer.deserialize(this.toString()));
    }

    @Override
    public byte[] asBytes() {
        return this.toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Properties asProperties() {
        Properties properties = new Properties();
        if (this != null) {
            for (Map.Entry<String, Object> mapEntry : this.asMap().entrySet()) {
                Object value = mapEntry.getValue();
                if (value instanceof Json) continue;
                properties.put(mapEntry.getKey(), value.toString());
            }
        }
        return properties;
    }

    protected Json withOptions(Json other, Json allOptions, String path) {
        if (!allOptions.has(path)) {
            allOptions.set(path, ObjectJson.object());
        }
        Json options = allOptions.at(path, ObjectJson.object());
        boolean duplicate = options.is("dup", (Object)true);
        if (options.is("merge", (Object)true)) {
            for (Map.Entry<String, Json> e : other.asJsonMap().entrySet()) {
                Json local = this.object.get(e.getKey());
                if (local instanceof ObjectJson) {
                    ((ObjectJson)local).withOptions(e.getValue(), allOptions, path + "/" + e.getKey());
                    continue;
                }
                if (local instanceof ArrayJson) {
                    ((ArrayJson)local).withOptions(e.getValue(), allOptions, path + "/" + e.getKey());
                    continue;
                }
                this.set(e.getKey(), duplicate ? e.getValue().dup() : e.getValue());
            }
        } else if (duplicate) {
            for (Map.Entry<String, Json> e : other.asJsonMap().entrySet()) {
                this.set(e.getKey(), e.getValue().dup());
            }
        } else {
            for (Map.Entry<String, Json> e : other.asJsonMap().entrySet()) {
                this.set(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    @Override
    public Json with(Json x, Json ... options) {
        if (x == null) {
            return this;
        }
        if (!x.isObject()) {
            throw new UnsupportedOperationException();
        }
        if (options.length > 0) {
            Json O = this.collectWithOptions(options);
            return this.withOptions(x, O, "");
        }
        for (Map.Entry<String, Json> e : x.asJsonMap().entrySet()) {
            this.set(e.getKey(), e.getValue());
        }
        return this;
    }

    @Override
    public Json set(String property, Json el) {
        if (property == null) {
            throw new IllegalArgumentException("Null property names are not allowed, value is " + el);
        }
        if (el == null) {
            el = ObjectJson.nil();
        }
        ObjectJson.setParent(el, this);
        this.object.put(property, el);
        return this;
    }

    @Override
    public Json atDel(String property) {
        Json el = this.object.remove(property);
        ObjectJson.removeParent(el, this);
        return el;
    }

    @Override
    public Json delAt(String property) {
        Json el = this.object.remove(property);
        ObjectJson.removeParent(el, this);
        return this;
    }

    @Override
    public Object getValue() {
        return this.asMap();
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Json> e : this.object.entrySet()) {
            m.put(e.getKey(), e.getValue().getValue());
        }
        return m;
    }

    @Override
    public Map<String, Json> asJsonMap() {
        return this.object;
    }

    public String toString() {
        return this.toString(Integer.MAX_VALUE);
    }

    @Override
    public String toString(int maxCharacters) {
        return this.toStringImpl(maxCharacters, new IdentityHashMap<Json, Json>());
    }

    String toStringImpl(int maxCharacters, Map<Json, Json> done) {
        StringBuilder sb = new StringBuilder("{");
        if (done.containsKey(this)) {
            return sb.append("...}").toString();
        }
        done.put(this, this);
        Iterator<Map.Entry<String, Json>> i = this.object.entrySet().iterator();
        while (i.hasNext()) {
            String s;
            Map.Entry<String, Json> x = i.next();
            sb.append('\"');
            sb.append(escaper.escapeJsonString(x.getKey()));
            sb.append('\"');
            sb.append(":");
            String string = x.getValue().isObject() ? ((ObjectJson)x.getValue()).toStringImpl(maxCharacters, done) : (s = x.getValue().isArray() ? ((ArrayJson)x.getValue()).toStringImpl(maxCharacters, done) : x.getValue().toString(maxCharacters));
            if (sb.length() + s.length() > maxCharacters) {
                s = s.substring(0, Math.max(0, maxCharacters - sb.length()));
            }
            sb.append(s);
            if (i.hasNext()) {
                sb.append(",");
            }
            if (sb.length() < maxCharacters) continue;
            sb.append("...");
            break;
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean equals(Object x) {
        return x instanceof ObjectJson && ((ObjectJson)x).object.equals(this.object);
    }
}

