/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.mjson;

import com.mohistmc.mjson.SAXHandler;
import com.mohistmc.mjson.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XmlUtils {
    public static final String DEFAULT_NAMESPACE_PREFIX = "ns1";
    private static final ThreadLocalSAXParser tlSAXParser = new ThreadLocalSAXParser();
    private static final ThreadLocalSAXHandler tlSAXHandler = new ThreadLocalSAXHandler();

    public static Map xmlToMap(InputSource in) {
        try {
            if (in == null) {
                return Map.of();
            }
            SAXHandler handler = XmlUtils.getSAXHandler();
            XmlUtils.getSAXParser().parse(in, (DefaultHandler)handler);
            return handler.getMap();
        }
        catch (Exception e) {
            return Map.of();
        }
    }

    public static String mapToXml(Map map, String namaspaceUri, String namespacePrefix) {
        if (map == null) {
            return null;
        }
        namaspaceUri = StringUtils.trimToNull(namaspaceUri);
        namespacePrefix = StringUtils.trimToNull(namespacePrefix);
        Iterator i = map.entrySet().iterator();
        if (!i.hasNext()) {
            return "";
        }
        Map.Entry root = i.next();
        StringBuffer buffer = new StringBuffer();
        StringBuilder tagName = new StringBuilder();
        if (namaspaceUri != null) {
            if (namespacePrefix == null) {
                namespacePrefix = DEFAULT_NAMESPACE_PREFIX;
            }
            tagName.append(namespacePrefix).append(':').append(root.getKey());
            buffer.append('<').append((CharSequence)tagName);
            buffer.append(" xmlns:").append(namespacePrefix).append("='").append(namaspaceUri).append("'");
        } else {
            tagName.append(root.getKey());
            buffer.append('<').append((CharSequence)tagName);
        }
        buffer.append('>');
        Object vo = root.getValue();
        if (vo instanceof String) {
            XmlUtils.escapeGeneralEntities((String)vo, buffer);
        } else if (vo instanceof Map) {
            XmlUtils.mapToXml((Map)vo, buffer);
        } else {
            throw new RuntimeException("Invalid value in Map. Value must be String or Map");
        }
        buffer.append("</").append((CharSequence)tagName).append('>');
        return buffer.toString();
    }

    public static String mapToXml(Map in) {
        StringBuffer buffer = new StringBuffer();
        XmlUtils.mapToXml(in, buffer);
        return buffer.toString();
    }

    public static void mapToXml(Map in, StringBuffer out) {
        for (Map.Entry object : in.entrySet()) {
            Map.Entry entry = object;
            Object vo = entry.getValue();
            if (vo instanceof String) {
                out.append('<').append(entry.getKey()).append('>');
                XmlUtils.escapeGeneralEntities((String)vo, out);
                out.append("</").append(entry.getKey()).append('>');
                continue;
            }
            if (vo instanceof Map) {
                out.append('<').append(entry.getKey()).append('>');
                XmlUtils.mapToXml((Map)vo, out);
                out.append("</").append(entry.getKey()).append('>');
                continue;
            }
            if (vo instanceof List) {
                for (Object o : (List)vo) {
                    out.append('<').append(entry.getKey()).append('>');
                    XmlUtils.mapToXml((Map)o, out);
                    out.append("</").append(entry.getKey()).append('>');
                }
                continue;
            }
            throw new RuntimeException("Invalid value in Map. Value must be String, Map or List");
        }
    }

    public static void escapeGeneralEntities(String text, StringBuffer out) {
        if (text == null) {
            return;
        }
        if (out == null) {
            throw new IllegalArgumentException("out is null");
        }
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            if (c == '>') {
                out.append("&gt;");
                continue;
            }
            out.append(c);
        }
    }

    public static SAXParser getSAXParser() {
        return (SAXParser)tlSAXParser.get();
    }

    public static SAXParserFactory getSAXFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory;
    }

    public static SAXHandler getSAXHandler() {
        return (SAXHandler)tlSAXHandler.get();
    }

    private static class ThreadLocalSAXParser
    extends ThreadLocal {
        private ThreadLocalSAXParser() {
        }

        protected Object initialValue() {
            try {
                return XmlUtils.getSAXFactory().newSAXParser();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ThreadLocalSAXHandler
    extends ThreadLocal {
        private ThreadLocalSAXHandler() {
        }

        protected Object initialValue() {
            return new SAXHandler();
        }
    }
}

