/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.mjson;

import com.mohistmc.mjson.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHandler
extends DefaultHandler {
    private boolean trimWhitespaces = true;
    private InternalElement currentElement;

    public SAXHandler() {
    }

    public SAXHandler(boolean trimWhitespaces) {
        this.trimWhitespaces = trimWhitespaces;
    }

    public Map getMap() {
        HashMap out = new HashMap();
        this.createMap(this.currentElement, out);
        return out;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        InternalElement newElement = new InternalElement();
        newElement.name = localName;
        if (this.currentElement != null) {
            if (this.currentElement.children == null) {
                this.currentElement.children = new ArrayList();
            }
            this.currentElement.children.add(newElement);
        } else {
            newElement.namespaceUri = StringUtils.trimToNull(uri);
        }
        newElement.parent = this.currentElement;
        this.currentElement = newElement;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.currentElement.value == null) {
            this.currentElement.value = new StringBuffer();
        }
        this.currentElement.value.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.currentElement.parent != null) {
            this.currentElement = this.currentElement.parent;
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    private void createMap(InternalElement element, HashMap out) {
        if (element == null) {
            throw new IllegalArgumentException("element is null");
        }
        if (out == null) {
            throw new IllegalArgumentException("out is null");
        }
        if (element.children == null) {
            this.put(out, element.name, element.value != null ? (this.trimWhitespaces ? element.value.toString().trim() : element.value.toString()) : "");
        } else {
            HashMap m = new HashMap();
            for (Object object : element.children) {
                this.createMap((InternalElement)object, m);
            }
            this.put(out, element.name, m);
        }
    }

    private void put(HashMap m, Object key, Object value) {
        Object o = m.get(key);
        if (o == null) {
            m.put(key, value);
            return;
        }
        if (o instanceof List) {
            ((List)o).add(value);
            return;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(o);
        l.add(value);
        m.put(key, l);
    }

    private static class InternalElement {
        String name;
        StringBuffer value;
        ArrayList children;
        InternalElement parent;
        String namespaceUri;

        private InternalElement() {
        }
    }
}

