/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.libraries;

import com.mohistmc.tools.ConnectionUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public enum DownloadSource {
    MOHISTMC("https://maven.mohistmc.com/libraries/"),
    CHINA("https://libraries.mohistmc.cn:25119/releases/libraries/"),
    GITHUB("https://mohistmc.github.io/maven/");

    public final String url;

    public static DownloadSource fast() {
        List<String> all1 = Arrays.stream(DownloadSource.values()).filter(downloadSource -> downloadSource != GITHUB).map(downloadSource -> DownloadSource.fixChinaUrl(downloadSource.url)).collect(Collectors.toList());
        String fastURL = ConnectionUtil.fastURL(all1);
        if (Objects.equals(DownloadSource.fixChinaUrl(DownloadSource.CHINA.url), fastURL)) {
            return CHINA;
        }
        if (Objects.equals(DownloadSource.MOHISTMC.url, fastURL)) {
            return MOHISTMC;
        }
        return GITHUB;
    }

    public static String fixChinaUrl(String url) {
        return url.replace("releases/", "");
    }

    public String getUrl() {
        return this.url;
    }

    private DownloadSource(String url) {
        this.url = url;
    }
}

