/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.tools;

public class NumberUtil {
    public static Integer toInt(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NullPointerException | NumberFormatException ignored) {
            return null;
        }
    }

    public static Double toDouble(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NullPointerException | NumberFormatException ignored) {
            return null;
        }
    }

    public static Long toLong(Object object) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (NullPointerException | NumberFormatException ignored) {
            return null;
        }
    }

    public static Float toFloat(Object object) {
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        try {
            return Float.valueOf(Float.parseFloat(object.toString()));
        }
        catch (NullPointerException | NumberFormatException ignored) {
            return null;
        }
    }

    public static Byte toByte(Object object) {
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        try {
            return Byte.parseByte(object.toString());
        }
        catch (NullPointerException | NumberFormatException ignored) {
            return null;
        }
    }

    public static Short toShort(Object object) {
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        try {
            return Short.parseShort(object.toString());
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static String getSize(int size) {
        return size >= 0x100000 ? size / 0x100000 + "MB" : (size >= 1024 ? size / 1024 + "KB" : size + "B");
    }
}

