/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.libraries.plugin;

import com.mohistmc.mjson.Json;
import com.mohistmc.tools.ConnectionUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LibraryLoader {
    private final Set<File> libraries = new HashSet<File>();
    private final Set<Dependency> newDependencies = new HashSet<Dependency>();
    private final Set<DependencyIgnoreVersion> dependencyIgnoreVersion = new HashSet<DependencyIgnoreVersion>();
    private final String plugin;
    private final List<URL> jarFiles = new ArrayList<URL>();
    private String source;
    private List<String> desc = new ArrayList<String>();
    private List<String> mohistLibs = new ArrayList<String>();
    private File targetFile = new File("libraries", "plugins-lib");

    public LibraryLoader(String plugin) {
        this.plugin = plugin;
    }

    public static LibraryLoader create(String plugin) {
        return new LibraryLoader(plugin);
    }

    public LibraryLoader source(String source) {
        this.source = source;
        return this;
    }

    public LibraryLoader libraries(List<String> desc) {
        this.desc = desc;
        return this;
    }

    public LibraryLoader mohistLibs(List<String> mohistLibs) {
        this.mohistLibs = mohistLibs;
        return this;
    }

    public LibraryLoader targetFile(File targetFile) {
        this.targetFile = targetFile;
        return this;
    }

    public LibraryLoader build() {
        String fileName;
        String group;
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String desc_libraries : this.desc) {
            Dependency dependency;
            String[] args = desc_libraries.split(":");
            if (args.length <= 1 || this.has(dependency = new Dependency(args[0], args[1], args[2], false))) continue;
            dependencies.add(dependency);
        }
        for (Dependency dependency : dependencies) {
            group = dependency.group().replace(".", "/");
            fileName = "%s-%s.pom".formatted(dependency.name(), dependency.version());
            if (this.has(dependency) || this.mohistLibs.contains(fileName)) continue;
            if (dependency.version().equalsIgnoreCase("LATEST")) {
                this.newDependencies.add(this.findDependency(group, dependency.name(), false));
                continue;
            }
            this.newDependencies.add(dependency);
            String pomUrl = this.source + "%s/%s/%s/%s".formatted(group, dependency.name(), dependency.version(), fileName);
            if (!ConnectionUtil.isValid(pomUrl)) continue;
            this.newDependencies.addAll(this.initDependencies0(pomUrl));
        }
        System.out.printf("[%s] Loading %s extra libraries... please wait%n", this.plugin, this.newDependencies.size() - this.desc.size());
        for (Dependency dependency : this.newDependencies) {
            group = dependency.group().replace(".", "/");
            fileName = "%s-%s.jar".formatted(dependency.name(), dependency.version());
            String mavenUrl = this.source + "%s/%s/%s/%s".formatted(group, dependency.name(), dependency.version(), fileName);
            File file = new File(this.targetFile, "%s/%s/%s/%s".formatted(group, dependency.name(), dependency.version(), fileName));
            if (this.has(dependency)) continue;
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
                InputStream inputStream = new URL(mavenUrl).openStream();
                ReadableByteChannel rbc = Channels.newChannel(inputStream);
                FileChannel fc = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                fc.transferFrom(rbc, 0L, Long.MAX_VALUE);
                fc.close();
                rbc.close();
                this.libraries.add(file);
            }
            catch (IOException iOException) {}
        }
        for (File file : this.libraries) {
            try {
                this.jarFiles.add(file.toURI().toURL());
                System.out.printf("[%s] Loaded libraries %s%n", this.plugin, file);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public Set<Dependency> initDependencies0(String url) {
        HashSet<Dependency> list = new HashSet<Dependency>();
        for (Dependency dependency : this.initDependencies(url)) {
            if (this.newDependencies.contains(dependency)) continue;
            list.add(dependency);
            if (this.dependencyIgnoreVersion.contains(dependency.toIgnoreVersion())) continue;
            this.dependencyIgnoreVersion.add(dependency.toIgnoreVersion());
            if (!dependency.extra()) continue;
            String group = dependency.group().replace(".", "/");
            String fileName = "%s-%s.pom".formatted(dependency.name(), dependency.version());
            String pomUrl = this.source + "%s/%s/%s/%s".formatted(group, dependency.name(), dependency.version(), fileName);
            if (!ConnectionUtil.isValid(pomUrl)) continue;
            list.addAll(this.initDependencies(pomUrl));
        }
        return list;
    }

    public Set<Dependency> initDependencies(String url) {
        String groupId;
        HashSet<Dependency> list = new HashSet<Dependency>();
        Json json = Json.readXml(url);
        if (json == null) {
            return list;
        }
        Json json2Json = json.at("project");
        String version = json2Json.has("parent") ? json2Json.at("parent").asString("version") : json2Json.asString("version");
        String string = groupId = json2Json.has("parent") ? json2Json.at("parent").asString("groupId") : json2Json.asString("groupId");
        if (!json2Json.has("dependencies")) {
            return list;
        }
        if (!json2Json.at("dependencies").toString().startsWith("{\"dependency\"")) {
            return list;
        }
        Json json3Json = json2Json.at("dependencies").at("dependency");
        if (json3Json.isArray()) {
            for (Json o : json2Json.at("dependencies").asJsonList("dependency")) {
                this.dependency(o, list, version, groupId);
            }
        } else {
            this.dependency(json3Json, list, version, groupId);
        }
        list.addAll(this.findDependency(list));
        return list;
    }

    public void dependency(Json json, Set<Dependency> list, String version, String parent_groupId) {
        try {
            if (json.has("groupId") && json.has("artifactId")) {
                String artifactId;
                DependencyIgnoreVersion d;
                String groupId = json.asString("groupId");
                if (groupId.startsWith("${")) {
                    groupId = parent_groupId;
                }
                if (this.dependencyIgnoreVersion.contains(d = new DependencyIgnoreVersion(groupId, artifactId = json.asString("artifactId")))) {
                    return;
                }
                if (json.has("optional")) {
                    return;
                }
                if (json.has("scope") && (json.asString("scope").equals("test") || json.asString("scope").equals("provided"))) {
                    return;
                }
                if (json.has("version")) {
                    String versionAsString = json.asString("version");
                    if (versionAsString.contains("${project.version}") || versionAsString.contains("${project.parent.version}")) {
                        Dependency dependency = new Dependency(groupId, artifactId, version, true);
                        list.add(dependency);
                    } else if (!versionAsString.contains("${")) {
                        Dependency dependency = new Dependency(groupId, artifactId, versionAsString, true);
                        list.add(dependency);
                    }
                } else if (json.has("scope") && json.asString("scope").equals("compile")) {
                    list.add(this.findDependency(groupId, artifactId, true));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Dependency findDependency(String groupId, String artifactId, boolean extra) {
        String mavenUrl = this.source + "%s/%s/%s".formatted(groupId.replace(".", "/"), artifactId, "maven-metadata.xml");
        Json compile_json2Json = Json.readXml(mavenUrl).at("metadata");
        List<Object> v = compile_json2Json.at("versioning").at("versions").at("version").asList();
        return new Dependency(groupId, artifactId, (String)v.get(v.size() - 1), extra);
    }

    public Set<Dependency> findDependency(Set<Dependency> dependencySet) {
        HashSet<Dependency> list = new HashSet<Dependency>();
        for (Dependency dependency : dependencySet) {
            if (this.dependencyIgnoreVersion.contains(dependency.toIgnoreVersion())) continue;
            this.dependencyIgnoreVersion.add(dependency.toIgnoreVersion());
            String group = dependency.group.replace(".", "/");
            String fileName = "%s-%s.pom".formatted(dependency.name, dependency.version);
            String pomUrl = this.source + "%s/%s/%s/%s".formatted(group, dependency.name, dependency.version, fileName);
            if (!ConnectionUtil.isValid(pomUrl)) continue;
            list.addAll(this.initDependencies(pomUrl));
        }
        return list;
    }

    public boolean has(Dependency dependency) {
        String fileName = "%s-%s.jar".formatted(dependency.name(), dependency.version());
        File file = new File(this.targetFile, "%s/%s/%s/%s".formatted(dependency.group, dependency.name, dependency.version(), fileName));
        if (file.exists() && !this.dependencyIgnoreVersion.contains(dependency.toIgnoreVersion())) {
            this.libraries.add(file);
            this.dependencyIgnoreVersion.add(dependency.toIgnoreVersion());
            System.out.printf("[%s] Found libraries %s%n", this.plugin, file);
            return true;
        }
        return false;
    }

    public List<URL> getJarFiles() {
        return this.jarFiles;
    }

    public record Dependency(String group, String name, String version, boolean extra) {
        public DependencyIgnoreVersion toIgnoreVersion() {
            return new DependencyIgnoreVersion(this.group, this.name);
        }
    }

    public record DependencyIgnoreVersion(String group, String name) {
    }
}

