/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.mjson;

import com.mohistmc.mjson.ArrayJson;
import com.mohistmc.mjson.BeanSerializer;
import com.mohistmc.mjson.BooleanJson;
import com.mohistmc.mjson.JSONSerializer;
import com.mohistmc.mjson.NullJson;
import com.mohistmc.mjson.NumberJson;
import com.mohistmc.mjson.ObjectJson;
import com.mohistmc.mjson.ParentArrayJson;
import com.mohistmc.mjson.StringJson;
import com.mohistmc.mjson.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.xml.sax.InputSource;

public class Json
implements Serializable {
    public static final Factory defaultFactory = new DefaultFactory();
    static final Escaper escaper = new Escaper(false);
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<Factory> threadFactory = new ThreadLocal();
    private static Factory globalFactory = defaultFactory;
    Json enclosing = null;

    protected Json() {
    }

    protected Json(Json enclosing) {
        this.enclosing = enclosing;
    }

    static String fetchContent(URL url) {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)url.getContent());
            StringBuilder content = new StringBuilder();
            char[] buf = new char[1024];
            int n = reader.read(buf);
            while (n > -1) {
                content.append(buf, 0, n);
                n = reader.read(buf);
            }
            String string = content.toString();
            return string;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (reader != null) {
                try {
                    ((java.io.Reader)reader).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    static Json resolvePointer(String pointerRepresentation, Json top) {
        String[] parts = pointerRepresentation.split("/");
        Json result = top;
        for (String p : parts) {
            if (p.isEmpty()) continue;
            p = p.replace("~1", "/").replace("~0", "~");
            if (result.isArray()) {
                result = result.at(Integer.parseInt(p));
                continue;
            }
            if (result.isObject()) {
                result = result.at(p);
                continue;
            }
            throw new RuntimeException("Can't resolve pointer " + pointerRepresentation + " on document " + top.toString(200));
        }
        return result;
    }

    static URI makeAbsolute(URI base, String ref) throws Exception {
        URI refuri;
        if (base != null && base.getAuthority() != null && !new URI(ref).isAbsolute()) {
            StringBuilder sb = new StringBuilder();
            if (base.getScheme() != null) {
                sb.append(base.getScheme()).append("://");
            }
            sb.append(base.getAuthority());
            if (!ref.startsWith("/")) {
                if (ref.startsWith("#")) {
                    sb.append(base.getPath());
                } else {
                    int slashIdx = base.getPath().lastIndexOf(47);
                    sb.append(slashIdx == -1 ? base.getPath() : base.getPath().substring(0, slashIdx)).append("/");
                }
            }
            refuri = new URI(sb.append(ref).toString());
        } else {
            refuri = base != null ? base.resolve(ref) : new URI(ref);
        }
        return refuri;
    }

    static Json resolveRef(URI base, Json refdoc, URI refuri, Map<String, Json> resolved, Map<Json, Json> expanded, Function<URI, Json> uriResolver) throws Exception {
        if (!(!refuri.isAbsolute() || base != null && base.isAbsolute() && base.getScheme().equals(refuri.getScheme()) && Objects.equals(base.getHost(), refuri.getHost()) && base.getPort() == refuri.getPort() && base.getPath().equals(refuri.getPath()))) {
            URI docuri = (refuri = refuri.normalize()).getHost() == null ? new URI(refuri.getScheme() + ":" + refuri.getPath()) : new URI(refuri.getScheme() + "://" + refuri.getHost() + (String)(refuri.getPort() > -1 ? ":" + refuri.getPort() : "") + refuri.getPath());
            refdoc = uriResolver.apply(docuri);
            refdoc = Json.expandReferences(refdoc, refdoc, docuri, resolved, expanded, uriResolver);
        }
        if (refuri.getFragment() == null) {
            return refdoc;
        }
        return Json.resolvePointer(refuri.getFragment(), refdoc);
    }

    static Json expandReferences(Json json, Json topdoc, URI base, Map<String, Json> resolved, Map<Json, Json> expanded, Function<URI, Json> uriResolver) throws Exception {
        if (expanded.containsKey(json)) {
            return json;
        }
        if (json.isObject()) {
            if (json.has("id") && json.at("id").isString()) {
                base = base.resolve(json.at("id").asString());
            }
            if (json.has("$ref")) {
                URI refuri = Json.makeAbsolute(base, json.at("$ref").asString());
                Json ref = resolved.get(refuri.toString());
                if (ref == null) {
                    ref = Json.object();
                    resolved.put(refuri.toString(), ref);
                    ref.with(Json.resolveRef(base, topdoc, refuri, resolved, expanded, uriResolver), new Object[0]);
                }
                json = ref;
            } else {
                for (Map.Entry<String, Json> e : json.asJsonMap().entrySet()) {
                    json.set(e.getKey(), Json.expandReferences(e.getValue(), topdoc, base, resolved, expanded, uriResolver));
                }
            }
        } else if (json.isArray()) {
            for (int i = 0; i < json.asJsonList().size(); ++i) {
                json.set(i, (Object)Json.expandReferences(json.at(i), topdoc, base, resolved, expanded, uriResolver));
            }
        }
        expanded.put(json, json);
        return json;
    }

    public static Schema schema(Json S) {
        return new DefaultSchema(null, S, null);
    }

    public static Schema schema(URI uri) {
        return Json.schema(uri, null);
    }

    public static Schema schema(URI uri, Function<URI, Json> relativeReferenceResolver) {
        try {
            return new DefaultSchema(uri, Json.read(Json.fetchContent(uri.toURL())), relativeReferenceResolver);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Schema schema(Json S, URI uri) {
        return new DefaultSchema(uri, S, null);
    }

    public static Factory factory() {
        Factory f = threadFactory.get();
        return f != null ? f : globalFactory;
    }

    public static void attachFactory(Factory factory) {
        threadFactory.set(factory);
    }

    public static void detachFactory() {
        threadFactory.remove();
    }

    public static Json read(String jsonAsString) {
        return (Json)new Reader().read(jsonAsString);
    }

    public static Json readXml(String urlAsString) {
        return Json.factory().make(XmlUtils.xmlToMap(new InputSource(urlAsString)));
    }

    public static Json read(URL location) {
        return (Json)new Reader().read(Json.fetchContent(location));
    }

    public static Json readXml(URL location) {
        return Json.readXml(location.toString());
    }

    public static Json read(Object object) {
        return Json.factory().make(object);
    }

    public static Json readBean(Object clazz) {
        return Json.read(JSONSerializer.serialize(BeanSerializer.serialize(clazz)));
    }

    public static Json read(Properties properties) {
        Json jo = Json.object();
        if (properties != null && !properties.isEmpty()) {
            Enumeration<?> enumProperties = properties.propertyNames();
            while (enumProperties.hasMoreElements()) {
                String name = (String)enumProperties.nextElement();
                jo.set(name, (Object)properties.getProperty(name));
            }
        }
        return jo;
    }

    public static Json read(CharacterIterator it) {
        return (Json)new Reader().read(it);
    }

    public static Json nil() {
        return Json.factory().nil();
    }

    public static Json object() {
        return Json.factory().object();
    }

    public static Json object(Object ... args) {
        Json j = Json.object();
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("An even number of arguments is expected.");
        }
        for (int i = 0; i < args.length; ++i) {
            j.set(args[i].toString(), Json.factory().make(args[++i]));
        }
        return j;
    }

    public static Json array() {
        return Json.factory().array();
    }

    public static Json array(Object ... args) {
        Json A = Json.array();
        for (Object x : args) {
            A.add(Json.factory().make(x));
        }
        return A;
    }

    public static Json make(Object anything) {
        return Json.factory().make(anything);
    }

    static void setParent(Json el, Json parent) {
        if (el.enclosing == null) {
            el.enclosing = parent;
        } else if (el.enclosing instanceof ParentArrayJson) {
            ((ParentArrayJson)el.enclosing).L.add(parent);
        } else {
            ParentArrayJson A = new ParentArrayJson();
            A.L.add(el.enclosing);
            A.L.add(parent);
            el.enclosing = A;
        }
    }

    static void removeParent(Json el, Json parent) {
        if (el.enclosing == parent) {
            el.enclosing = null;
        } else if (el.enclosing.isArray()) {
            ArrayJson A = (ArrayJson)el.enclosing;
            int idx = 0;
            while (A.L.get(idx) != parent) {
                ++idx;
            }
            if (idx < A.L.size()) {
                A.L.remove(idx);
            }
        }
    }

    public String toString(int maxCharacters) {
        return this.toString();
    }

    public void attachTo(Json enclosing) {
        this.enclosing = enclosing;
    }

    public final Json up() {
        return this.enclosing;
    }

    public Json dup() {
        return this;
    }

    public Json at(int index) {
        throw new UnsupportedOperationException();
    }

    public Json at(String property) {
        throw new UnsupportedOperationException();
    }

    public final Json at(String property, Json def) {
        Json x = this.at(property);
        if (x == null) {
            return def;
        }
        return x;
    }

    public final Json at(String property, Object def) {
        return this.at(property, Json.make(def));
    }

    public boolean has(String property) {
        throw new UnsupportedOperationException();
    }

    public boolean is(String property, Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean is(int index, Object value) {
        throw new UnsupportedOperationException();
    }

    public Json add(Json el) {
        throw new UnsupportedOperationException();
    }

    public final Json add(Object anything) {
        return this.add(Json.make(anything));
    }

    public Json atDel(String property) {
        throw new UnsupportedOperationException();
    }

    public Json atDel(int index) {
        throw new UnsupportedOperationException();
    }

    public Json delAt(String property) {
        throw new UnsupportedOperationException();
    }

    public Json delAt(int index) {
        throw new UnsupportedOperationException();
    }

    public Json remove(Json el) {
        throw new UnsupportedOperationException();
    }

    public final Json remove(Object anything) {
        return this.remove(Json.make(anything));
    }

    public Json set(String property, Json value) {
        throw new UnsupportedOperationException();
    }

    public final Json set(String property, Object value) {
        return this.set(property, Json.make(value));
    }

    public Json set(int index, Object value) {
        throw new UnsupportedOperationException();
    }

    public Json with(Json object, Json[] options) {
        throw new UnsupportedOperationException();
    }

    public Json with(Json object, Object ... options) {
        Json[] jopts = new Json[options.length];
        for (int i = 0; i < jopts.length; ++i) {
            jopts[i] = Json.make(options[i]);
        }
        return this.with(object, jopts);
    }

    public Object getValue() {
        throw new UnsupportedOperationException();
    }

    public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    public String asString() {
        throw new UnsupportedOperationException();
    }

    public int asInteger() {
        throw new UnsupportedOperationException();
    }

    public float asFloat() {
        throw new UnsupportedOperationException();
    }

    public double asDouble() {
        throw new UnsupportedOperationException();
    }

    public long asLong() {
        throw new UnsupportedOperationException();
    }

    public short asShort() {
        throw new UnsupportedOperationException();
    }

    public byte asByte() {
        throw new UnsupportedOperationException();
    }

    public char asChar() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> asMap() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Json> asJsonMap() {
        throw new UnsupportedOperationException();
    }

    public List<Object> asList() {
        throw new UnsupportedOperationException();
    }

    public List<Json> asJsonList() {
        throw new UnsupportedOperationException();
    }

    public boolean asBoolean(String property) {
        throw new UnsupportedOperationException();
    }

    public String asString(String property) {
        throw new UnsupportedOperationException();
    }

    public int asInteger(String property) {
        throw new UnsupportedOperationException();
    }

    public float asFloat(String property) {
        throw new UnsupportedOperationException();
    }

    public double asDouble(String property) {
        throw new UnsupportedOperationException();
    }

    public long asLong(String property) {
        throw new UnsupportedOperationException();
    }

    public short asShort(String property) {
        throw new UnsupportedOperationException();
    }

    public byte asByte(String property) {
        throw new UnsupportedOperationException();
    }

    public char asChar(String property) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> asMap(String property) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Json> asJsonMap(String property) {
        throw new UnsupportedOperationException();
    }

    public List<Object> asList(String property) {
        throw new UnsupportedOperationException();
    }

    public List<Json> asJsonList(String property) {
        throw new UnsupportedOperationException();
    }

    public <T> T asBean(Class<T> classZ) {
        throw new UnsupportedOperationException();
    }

    public Properties asProperties() {
        throw new UnsupportedOperationException();
    }

    public byte[] asBytes() {
        throw new UnsupportedOperationException();
    }

    public boolean isNull() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isPrimitive() {
        return this.isString() || this.isNumber() || this.isBoolean();
    }

    public String pad(String callback) {
        return callback != null && !callback.isEmpty() ? callback + "(" + this + ");" : this.toString();
    }

    protected Json collectWithOptions(Json ... options) {
        Json result = Json.object();
        for (Json opt : options) {
            Json forPaths;
            if (opt.isString()) {
                if (!result.has("")) {
                    result.set("", Json.object());
                }
                result.at("").set(opt.asString(), (Object)true);
                continue;
            }
            if (!opt.has("for")) {
                opt.set("for", Json.array(""));
            }
            if (!(forPaths = opt.at("for")).isArray()) {
                forPaths = Json.array(forPaths);
            }
            for (Json path : forPaths.asJsonList()) {
                if (!result.has(path.asString())) {
                    result.set(path.asString(), Json.object());
                }
                Json at_path = result.at(path.asString());
                at_path.set("merge", (Object)opt.is("merge", (Object)true));
                at_path.set("dup", (Object)opt.is("dup", (Object)true));
                at_path.set("sort", (Object)opt.is("sort", (Object)true));
                at_path.set("compareBy", opt.at("compareBy", Json.nil()));
            }
        }
        return result;
    }

    public static void setGlobalFactory(Factory globalFactory) {
        Json.globalFactory = globalFactory;
    }

    public static interface Function<T, R> {
        public R apply(T var1);
    }

    static class DefaultSchema
    implements Schema {
        static final Instruction any = param -> null;
        final int maxchars = 50;
        URI uri;
        Json theschema;
        Instruction start;

        DefaultSchema(URI uri, Json theschema, Function<URI, Json> relativeReferenceResolver) {
            try {
                URI uRI = this.uri = uri == null ? new URI("") : uri;
                if (relativeReferenceResolver == null) {
                    relativeReferenceResolver = docuri -> {
                        try {
                            return Json.read(Json.fetchContent(docuri.toURL()));
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    };
                }
                this.theschema = theschema.dup();
                this.theschema = Json.expandReferences(this.theschema, this.theschema, this.uri, new LinkedHashMap<String, Json>(), new IdentityHashMap<Json, Json>(), relativeReferenceResolver);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.start = this.compile(this.theschema, new IdentityHashMap<Json, Instruction>());
        }

        static Json maybeError(Json errors, Json E) {
            return E == null ? errors : (errors == null ? Json.array() : errors).with(E, new Json[0]);
        }

        Instruction compile(Json S, Map<Json, Instruction> compiled) {
            Object any;
            Instruction result = compiled.get(S);
            if (result != null) {
                return result;
            }
            Sequence seq = new Sequence();
            compiled.put(S, seq);
            if (S.has("type") && !S.is("type", (Object)"any")) {
                seq.add(new CheckType(S.at("type").isString() ? Json.array().add(S.at("type")) : S.at("type")));
            }
            if (S.has("enum")) {
                seq.add(new CheckEnum(S.at("enum")));
            }
            if (S.has("allOf")) {
                Sequence sub = new Sequence();
                for (Json json : S.at("allOf").asJsonList()) {
                    sub.add(this.compile(json, compiled));
                }
                seq.add(sub);
            }
            if (S.has("anyOf")) {
                any = new CheckAny();
                ((CheckAny)any).schema = S.at("anyOf");
                for (Json json : ((CheckAny)any).schema.asJsonList()) {
                    ((CheckAny)any).alternates.add(this.compile(json, compiled));
                }
                seq.add((Instruction)any);
            }
            if (S.has("oneOf")) {
                any = new CheckOne();
                ((CheckOne)any).schema = S.at("oneOf");
                for (Json json : ((CheckOne)any).schema.asJsonList()) {
                    ((CheckOne)any).alternates.add(this.compile(json, compiled));
                }
                seq.add((Instruction)any);
            }
            if (S.has("not")) {
                seq.add(new CheckNot(this.compile(S.at("not"), compiled), S.at("not")));
            }
            if (S.has("required") && S.at("required").isArray()) {
                for (Json json : S.at("required").asJsonList()) {
                    seq.add(new CheckPropertyPresent(json.asString()));
                }
            }
            CheckObject objectCheck = new CheckObject();
            if (S.has("properties")) {
                for (Map.Entry<String, Json> entry : S.at("properties").asJsonMap().entrySet()) {
                    objectCheck.props.add(new CheckObject.CheckProperty(entry.getKey(), this.compile(entry.getValue(), compiled)));
                }
            }
            if (S.has("patternProperties")) {
                for (Map.Entry<String, Json> entry : S.at("patternProperties").asJsonMap().entrySet()) {
                    objectCheck.patternProps.add(new CheckObject.CheckPatternProperty(entry.getKey(), this.compile(entry.getValue(), compiled)));
                }
            }
            if (S.has("additionalProperties")) {
                if (S.at("additionalProperties").isObject()) {
                    objectCheck.additionalSchema = this.compile(S.at("additionalProperties"), compiled);
                } else if (!S.at("additionalProperties").asBoolean()) {
                    objectCheck.additionalSchema = null;
                }
            }
            if (S.has("minProperties")) {
                objectCheck.min = S.at("minProperties").asInteger();
            }
            if (S.has("maxProperties")) {
                objectCheck.max = S.at("maxProperties").asInteger();
            }
            if (!objectCheck.props.isEmpty() || !objectCheck.patternProps.isEmpty() || objectCheck.additionalSchema != DefaultSchema.any || objectCheck.min > 0 || objectCheck.max < Integer.MAX_VALUE) {
                seq.add(objectCheck);
            }
            CheckArray checkArray = new CheckArray();
            if (S.has("items")) {
                if (S.at("items").isObject()) {
                    checkArray.schema = this.compile(S.at("items"), compiled);
                } else {
                    checkArray.schemas = new ArrayList();
                    for (Json s : S.at("items").asJsonList()) {
                        checkArray.schemas.add(this.compile(s, compiled));
                    }
                }
            }
            if (S.has("additionalItems")) {
                if (S.at("additionalItems").isObject()) {
                    checkArray.additionalSchema = this.compile(S.at("additionalItems"), compiled);
                } else if (!S.at("additionalItems").asBoolean()) {
                    checkArray.additionalSchema = null;
                }
            }
            if (S.has("uniqueItems")) {
                checkArray.uniqueitems = S.at("uniqueItems").asBoolean();
            }
            if (S.has("minItems")) {
                checkArray.min = S.at("minItems").asInteger();
            }
            if (S.has("maxItems")) {
                checkArray.max = S.at("maxItems").asInteger();
            }
            if (checkArray.schema != null || checkArray.schemas != null || checkArray.additionalSchema != DefaultSchema.any || checkArray.uniqueitems != null || checkArray.max < Integer.MAX_VALUE || checkArray.min > 0) {
                seq.add(checkArray);
            }
            CheckNumber checkNumber = new CheckNumber();
            if (S.has("minimum")) {
                checkNumber.min = S.at("minimum").asDouble();
            }
            if (S.has("maximum")) {
                checkNumber.max = S.at("maximum").asDouble();
            }
            if (S.has("multipleOf")) {
                checkNumber.multipleOf = S.at("multipleOf").asDouble();
            }
            if (S.has("exclusiveMinimum")) {
                checkNumber.exclusiveMin = S.at("exclusiveMinimum").asBoolean();
            }
            if (S.has("exclusiveMaximum")) {
                checkNumber.exclusiveMax = S.at("exclusiveMaximum").asBoolean();
            }
            if (!(Double.isNaN(checkNumber.min) && Double.isNaN(checkNumber.max) && Double.isNaN(checkNumber.multipleOf))) {
                seq.add(checkNumber);
            }
            CheckString stringCheck = new CheckString();
            if (S.has("minLength")) {
                stringCheck.min = S.at("minLength").asInteger();
            }
            if (S.has("maxLength")) {
                stringCheck.max = S.at("maxLength").asInteger();
            }
            if (S.has("pattern")) {
                stringCheck.pattern = Pattern.compile(S.at("pattern").asString());
            }
            if (stringCheck.min > 0 || stringCheck.max < Integer.MAX_VALUE || stringCheck.pattern != null) {
                seq.add(stringCheck);
            }
            if (S.has("dependencies")) {
                for (Map.Entry<String, Json> e : S.at("dependencies").asJsonMap().entrySet()) {
                    if (e.getValue().isObject()) {
                        seq.add(new CheckSchemaDependency(e.getKey(), this.compile(e.getValue(), compiled)));
                        continue;
                    }
                    if (e.getValue().isArray()) {
                        seq.add(new CheckPropertyDependency(e.getKey(), e.getValue()));
                        continue;
                    }
                    seq.add(new CheckPropertyDependency(e.getKey(), Json.array(e.getValue())));
                }
            }
            result = seq.seq.size() == 1 ? seq.seq.get(0) : seq;
            compiled.put(S, result);
            return result;
        }

        @Override
        public Json validate(Json document) {
            Json result = Json.object("ok", true);
            Json errors = (Json)this.start.apply(document);
            return errors == null ? result : result.set("errors", errors).set("ok", (Object)false);
        }

        @Override
        public Json toJson() {
            return this.theschema;
        }

        public Json generate(Json options) {
            return Json.nil();
        }

        static interface Instruction
        extends Function<Json, Json> {
        }

        static class Sequence
        implements Instruction {
            final ArrayList<Instruction> seq = new ArrayList();

            Sequence() {
            }

            @Override
            public Json apply(Json param) {
                Json errors = null;
                for (Instruction I : this.seq) {
                    errors = DefaultSchema.maybeError(errors, (Json)I.apply(param));
                }
                return errors;
            }

            public Sequence add(Instruction I) {
                this.seq.add(I);
                return this;
            }
        }

        class CheckType
        implements Instruction {
            final Json types;

            public CheckType(Json types) {
                this.types = types;
            }

            @Override
            public Json apply(Json param) {
                String ptype = param.isString() ? "string" : (param.isObject() ? "object" : (param.isArray() ? "array" : (param.isNumber() ? "number" : (param.isNull() ? "null" : "boolean"))));
                for (Json type : this.types.asJsonList()) {
                    if (type.asString().equals(ptype)) {
                        return null;
                    }
                    if (!type.asString().equals("integer") || !param.isNumber() || param.asDouble() % 1.0 != 0.0) continue;
                    return null;
                }
                return Json.array().add(Json.make("Type mistmatch for " + param.toString(50) + ", allowed types: " + this.types));
            }
        }

        class CheckEnum
        implements Instruction {
            final Json theenum;

            public CheckEnum(Json theenum) {
                this.theenum = theenum;
            }

            @Override
            public Json apply(Json param) {
                for (Json option : this.theenum.asJsonList()) {
                    if (!param.equals(option)) continue;
                    return null;
                }
                return Json.array().add("Element " + param.toString(50) + " doesn't match any of enumerated possibilities " + this.theenum);
            }
        }

        class CheckAny
        implements Instruction {
            final ArrayList<Instruction> alternates = new ArrayList();
            Json schema;

            CheckAny() {
            }

            @Override
            public Json apply(Json param) {
                for (Instruction I : this.alternates) {
                    if (I.apply(param) != null) continue;
                    return null;
                }
                return Json.array().add("Element " + param.toString(50) + " must conform to at least one of available sub-schemas " + this.schema.toString(50));
            }
        }

        class CheckOne
        implements Instruction {
            final ArrayList<Instruction> alternates = new ArrayList();
            Json schema;

            CheckOne() {
            }

            @Override
            public Json apply(Json param) {
                int matches = 0;
                Json errors = Json.array();
                for (Instruction I : this.alternates) {
                    Json result = (Json)I.apply(param);
                    if (result == null) {
                        ++matches;
                        continue;
                    }
                    errors.add(result);
                }
                if (matches != 1) {
                    return Json.array().add("Element " + param.toString(50) + " must conform to exactly one of available sub-schemas, but not more " + this.schema.toString(50)).add(errors);
                }
                return null;
            }
        }

        class CheckNot
        implements Instruction {
            final Instruction I;
            final Json schema;

            public CheckNot(Instruction I, Json schema) {
                this.I = I;
                this.schema = schema;
            }

            @Override
            public Json apply(Json param) {
                if (this.I.apply(param) != null) {
                    return null;
                }
                return Json.array().add("Element " + param.toString(50) + " must NOT conform to the schema " + this.schema.toString(50));
            }
        }

        class CheckPropertyPresent
        implements Instruction {
            final String propname;

            public CheckPropertyPresent(String propname) {
                this.propname = propname;
            }

            @Override
            public Json apply(Json param) {
                if (!param.isObject()) {
                    return null;
                }
                if (param.has(this.propname)) {
                    return null;
                }
                return Json.array().add(Json.make("Required property " + this.propname + " missing from object " + param.toString(50)));
            }
        }

        class CheckObject
        implements Instruction {
            final ArrayList<CheckProperty> props = new ArrayList();
            final ArrayList<CheckPatternProperty> patternProps = new ArrayList();
            int min = 0;
            int max = Integer.MAX_VALUE;
            Instruction additionalSchema = any;

            CheckObject() {
            }

            @Override
            public Json apply(Json param) {
                Json errors = null;
                if (!param.isObject()) {
                    return null;
                }
                HashSet<String> checked = new HashSet<String>();
                for (CheckProperty checkProperty : this.props) {
                    if (param.has(checkProperty.name)) {
                        checked.add(checkProperty.name);
                    }
                    errors = DefaultSchema.maybeError(errors, checkProperty.apply(param));
                }
                for (CheckPatternProperty checkPatternProperty : this.patternProps) {
                    errors = DefaultSchema.maybeError(errors, checkPatternProperty.apply(param, checked));
                }
                if (this.additionalSchema != any) {
                    for (Map.Entry entry : param.asJsonMap().entrySet()) {
                        if (checked.contains(entry.getKey())) continue;
                        errors = DefaultSchema.maybeError(errors, this.additionalSchema == null ? Json.make("Extra property '" + (String)entry.getKey() + "', schema doesn't allow any properties not explicitly defined:" + param.toString(50)) : (Json)this.additionalSchema.apply((Json)entry.getValue()));
                    }
                }
                if (param.asJsonMap().size() < this.min) {
                    errors = DefaultSchema.maybeError(errors, Json.make("Object " + param.toString(50) + " has fewer than the permitted " + this.min + "  number of properties."));
                }
                if (param.asJsonMap().size() > this.max) {
                    errors = DefaultSchema.maybeError(errors, Json.make("Object " + param.toString(50) + " has more than the permitted " + this.min + "  number of properties."));
                }
                return errors;
            }

            static class CheckProperty
            implements Instruction {
                final String name;
                final Instruction schema;

                public CheckProperty(String name, Instruction schema) {
                    this.name = name;
                    this.schema = schema;
                }

                @Override
                public Json apply(Json param) {
                    Json value = param.at(this.name);
                    if (value == null) {
                        return null;
                    }
                    return (Json)this.schema.apply(param.at(this.name));
                }
            }

            static class CheckPatternProperty {
                final Pattern pattern;
                final Instruction schema;

                public CheckPatternProperty(String pattern, Instruction schema) {
                    this.pattern = Pattern.compile(pattern);
                    this.schema = schema;
                }

                public Json apply(Json param, Set<String> found) {
                    Json errors = null;
                    for (Map.Entry<String, Json> e : param.asJsonMap().entrySet()) {
                        if (!this.pattern.matcher(e.getKey()).find()) continue;
                        found.add(e.getKey());
                        errors = DefaultSchema.maybeError(errors, (Json)this.schema.apply(e.getValue()));
                    }
                    return errors;
                }
            }
        }

        class CheckArray
        implements Instruction {
            int min = 0;
            int max = Integer.MAX_VALUE;
            Boolean uniqueitems = null;
            Instruction additionalSchema = any;
            Instruction schema;
            ArrayList<Instruction> schemas;

            CheckArray() {
            }

            @Override
            public Json apply(Json param) {
                Json errors = null;
                if (!param.isArray()) {
                    return null;
                }
                if (this.schema == null && this.schemas == null && this.additionalSchema == null) {
                    return null;
                }
                int size = param.asJsonList().size();
                for (int i = 0; i < size; ++i) {
                    Instruction S = this.schema != null ? this.schema : (this.schemas != null && i < this.schemas.size() ? this.schemas.get(i) : this.additionalSchema);
                    errors = S == null ? DefaultSchema.maybeError(errors, Json.make("Additional items are not permitted: " + param.at(i) + " in " + param.toString(50))) : DefaultSchema.maybeError(errors, (Json)S.apply(param.at(i)));
                    if (this.uniqueitems != null && this.uniqueitems.booleanValue() && param.asJsonList().lastIndexOf(param.at(i)) > i) {
                        errors = DefaultSchema.maybeError(errors, Json.make("Element " + param.at(i) + " is duplicate in array."));
                    }
                    if (errors != null && !errors.asJsonList().isEmpty()) break;
                }
                if (size < this.min || size > this.max) {
                    errors = DefaultSchema.maybeError(errors, Json.make("Array  " + param.toString(50) + " has number of elements outside of the permitted range [" + this.min + "," + this.max + "]."));
                }
                return errors;
            }
        }

        static class CheckNumber
        implements Instruction {
            double min = Double.NaN;
            double max = Double.NaN;
            double multipleOf = Double.NaN;
            boolean exclusiveMin = false;
            boolean exclusiveMax = false;

            CheckNumber() {
            }

            @Override
            public Json apply(Json param) {
                Json errors = null;
                if (!param.isNumber()) {
                    return null;
                }
                double value = param.asDouble();
                if (!Double.isNaN(this.min) && (value < this.min || this.exclusiveMin && value == this.min)) {
                    errors = DefaultSchema.maybeError(null, Json.make("Number " + param + " is below allowed minimum " + this.min));
                }
                if (!Double.isNaN(this.max) && (value > this.max || this.exclusiveMax && value == this.max)) {
                    errors = DefaultSchema.maybeError(errors, Json.make("Number " + param + " is above allowed maximum " + this.max));
                }
                if (!Double.isNaN(this.multipleOf) && value / this.multipleOf % 1.0 != 0.0) {
                    errors = DefaultSchema.maybeError(errors, Json.make("Number " + param + " is not a multiple of  " + this.multipleOf));
                }
                return errors;
            }
        }

        class CheckString
        implements Instruction {
            int min = 0;
            int max = Integer.MAX_VALUE;
            Pattern pattern;

            CheckString() {
            }

            @Override
            public Json apply(Json param) {
                Json errors = null;
                if (!param.isString()) {
                    return null;
                }
                String s = param.asString();
                int size = s.codePointCount(0, s.length());
                if (size < this.min || size > this.max) {
                    errors = DefaultSchema.maybeError(null, Json.make("String  " + param.toString(50) + " has length outside of the permitted range [" + this.min + "," + this.max + "]."));
                }
                if (this.pattern != null && !this.pattern.matcher(s).matches()) {
                    errors = DefaultSchema.maybeError(errors, Json.make("String  " + param.toString(50) + " does not match regex " + this.pattern.toString()));
                }
                return errors;
            }
        }

        static class CheckSchemaDependency
        implements Instruction {
            final Instruction schema;
            final String property;

            public CheckSchemaDependency(String property, Instruction schema) {
                this.property = property;
                this.schema = schema;
            }

            @Override
            public Json apply(Json param) {
                if (!param.isObject()) {
                    return null;
                }
                if (!param.has(this.property)) {
                    return null;
                }
                return (Json)this.schema.apply(param);
            }
        }

        class CheckPropertyDependency
        implements Instruction {
            final Json required;
            final String property;

            public CheckPropertyDependency(String property, Json required) {
                this.property = property;
                this.required = required;
            }

            @Override
            public Json apply(Json param) {
                if (!param.isObject()) {
                    return null;
                }
                if (!param.has(this.property)) {
                    return null;
                }
                Json errors = null;
                for (Json p : this.required.asJsonList()) {
                    if (param.has(p.asString())) continue;
                    errors = DefaultSchema.maybeError(errors, Json.make("Conditionally required property " + p + " missing from object " + param.toString(50)));
                }
                return errors;
            }
        }

        class IsInteger
        implements Instruction {
            IsInteger() {
            }

            @Override
            public Json apply(Json param) {
                return param.isNumber() && param.getValue() instanceof Integer ? null : Json.make(param.toString(50));
            }
        }

        class IsNumber
        implements Instruction {
            IsNumber() {
            }

            @Override
            public Json apply(Json param) {
                return param.isNumber() ? null : Json.make(param.toString(50));
            }
        }

        class IsNull
        implements Instruction {
            IsNull() {
            }

            @Override
            public Json apply(Json param) {
                return param.isNull() ? null : Json.make(param.toString(50));
            }
        }

        class IsBoolean
        implements Instruction {
            IsBoolean() {
            }

            @Override
            public Json apply(Json param) {
                return param.isBoolean() ? null : Json.make(param.toString(50));
            }
        }

        class IsString
        implements Instruction {
            IsString() {
            }

            @Override
            public Json apply(Json param) {
                return param.isString() ? null : Json.make(param.toString(50));
            }
        }

        class IsArray
        implements Instruction {
            IsArray() {
            }

            @Override
            public Json apply(Json param) {
                return param.isArray() ? null : Json.make(param.toString(50));
            }
        }

        class IsObject
        implements Instruction {
            IsObject() {
            }

            @Override
            public Json apply(Json param) {
                return param.isObject() ? null : Json.make(param.toString(50));
            }
        }
    }

    public static interface Schema {
        public Json validate(Json var1);

        public Json toJson();
    }

    public static interface Factory {
        public Json nil();

        public Json bool(boolean var1);

        public Json string(String var1);

        public Json number(Number var1);

        public Json object();

        public Json array();

        public Json make(Object var1);
    }

    private static class Reader {
        public static final int FIRST = 0;
        public static final int CURRENT = 1;
        public static final int NEXT = 2;
        private static final Object OBJECT_END = "}";
        private static final Object ARRAY_END = "]";
        private static final Object OBJECT_START = "{";
        private static final Object ARRAY_START = "[";
        private static final Object COLON = ":";
        private static final Object COMMA = ",";
        private static final HashSet<Object> PUNCTUATION = new HashSet<Object>(Arrays.asList(OBJECT_END, OBJECT_START, ARRAY_END, ARRAY_START, COLON, COMMA));
        private static final Map<Character, Character> escapes = new HashMap<Character, Character>();
        private final StringBuffer buf = new StringBuffer();
        private CharacterIterator it;
        private char c;
        private Object token;

        private Reader() {
        }

        private char next() {
            if (this.it.getIndex() == this.it.getEndIndex()) {
                throw new MalformedJsonException("Reached end of input at the " + this.it.getIndex() + "th character.");
            }
            this.c = this.it.next();
            return this.c;
        }

        private char previous() {
            this.c = this.it.previous();
            return this.c;
        }

        private void skipWhiteSpace() {
            do {
                if (Character.isWhitespace(this.c)) continue;
                if (this.c != '/') break;
                this.next();
                if (this.c == '*') {
                    while (this.c != '\uffff' && (this.next() != '*' || this.next() != '/')) {
                    }
                    if (this.c != '\uffff') continue;
                    throw new MalformedJsonException("Unterminated comment while parsing JSON string.");
                }
                if (this.c == '/') {
                    while (this.c != '\n' && this.c != '\uffff') {
                        this.next();
                    }
                } else {
                    this.previous();
                    break;
                }
            } while (this.next() != '\uffff');
        }

        public Object read(CharacterIterator ci, int start) {
            this.it = ci;
            switch (start) {
                case 0: {
                    this.c = this.it.first();
                    break;
                }
                case 1: {
                    this.c = this.it.current();
                    break;
                }
                case 2: {
                    this.c = this.it.next();
                }
            }
            return this.read();
        }

        public Object read(CharacterIterator it) {
            return this.read(it, 2);
        }

        public Object read(String string) {
            return this.read(new StringCharacterIterator(string), 0);
        }

        private void expected(Object expectedToken, Object actual) {
            if (expectedToken != actual) {
                throw new MalformedJsonException("Expected " + expectedToken + ", but got " + actual + " instead");
            }
        }

        private <T> T read() {
            this.skipWhiteSpace();
            char ch = this.c;
            this.next();
            switch (ch) {
                case '\"': {
                    this.token = this.readString();
                    break;
                }
                case '[': {
                    this.token = this.readArray();
                    break;
                }
                case ']': {
                    this.token = ARRAY_END;
                    break;
                }
                case ',': {
                    this.token = COMMA;
                    break;
                }
                case '{': {
                    this.token = this.readObject();
                    break;
                }
                case '}': {
                    this.token = OBJECT_END;
                    break;
                }
                case ':': {
                    this.token = COLON;
                    break;
                }
                case 't': {
                    if (this.c != 'r' || this.next() != 'u' || this.next() != 'e') {
                        throw new MalformedJsonException("Invalid JSON token: expected 'true' keyword.");
                    }
                    this.next();
                    this.token = Json.factory().bool(Boolean.TRUE);
                    break;
                }
                case 'f': {
                    if (this.c != 'a' || this.next() != 'l' || this.next() != 's' || this.next() != 'e') {
                        throw new MalformedJsonException("Invalid JSON token: expected 'false' keyword.");
                    }
                    this.next();
                    this.token = Json.factory().bool(Boolean.FALSE);
                    break;
                }
                case 'n': {
                    if (this.c != 'u' || this.next() != 'l' || this.next() != 'l') {
                        throw new MalformedJsonException("Invalid JSON token: expected 'null' keyword.");
                    }
                    this.next();
                    this.token = Json.nil();
                    break;
                }
                default: {
                    this.c = this.it.previous();
                    if (Character.isDigit(this.c) || this.c == '-') {
                        this.token = this.readNumber();
                        break;
                    }
                    throw new MalformedJsonException("Invalid JSON near position: " + this.it.getIndex());
                }
            }
            return (T)this.token;
        }

        private String readObjectKey() {
            Object key = this.read();
            if (key == null) {
                throw new MalformedJsonException("Missing object key (don't forget to put quotes!).");
            }
            if (key == OBJECT_END) {
                return null;
            }
            if (PUNCTUATION.contains(key)) {
                throw new MalformedJsonException("Missing object key, found: " + key);
            }
            return ((Json)key).asString();
        }

        private Json readObject() {
            Json ret = Json.object();
            String key = this.readObjectKey();
            while (this.token != OBJECT_END) {
                this.expected(COLON, this.read());
                if (this.token == OBJECT_END) continue;
                Json value = (Json)this.read();
                ret.set(key, value);
                if (this.read() == COMMA) {
                    key = this.readObjectKey();
                    if (key != null && !PUNCTUATION.contains(key)) continue;
                    throw new MalformedJsonException("Expected a property name, but found: " + key);
                }
                this.expected(OBJECT_END, this.token);
            }
            return ret;
        }

        private Json readArray() {
            Json ret = Json.array();
            Object value = this.read();
            while (this.token != ARRAY_END) {
                if (PUNCTUATION.contains(value)) {
                    throw new MalformedJsonException("Expected array element, but found: " + value);
                }
                ret.add((Json)value);
                if (this.read() == COMMA) {
                    value = this.read();
                    if (value != ARRAY_END) continue;
                    throw new MalformedJsonException("Expected array element, but found end of array after command.");
                }
                this.expected(ARRAY_END, this.token);
            }
            return ret;
        }

        private Json readNumber() {
            int length = 0;
            boolean isFloatingPoint = false;
            this.buf.setLength(0);
            if (this.c == '-') {
                this.add();
            }
            length += this.addDigits();
            if (this.c == '.') {
                this.add();
                length += this.addDigits();
                isFloatingPoint = true;
            }
            if (this.c == 'e' || this.c == 'E') {
                this.add();
                if (this.c == '+' || this.c == '-') {
                    this.add();
                }
                this.addDigits();
                isFloatingPoint = true;
            }
            String s = this.buf.toString();
            Number n = isFloatingPoint ? (Number)(length < 17 ? Double.valueOf(s) : new BigDecimal(s)) : (Number)(length < 20 ? Long.valueOf(s) : new BigInteger(s));
            return Json.factory().number(n);
        }

        private int addDigits() {
            int ret = 0;
            while (Character.isDigit(this.c)) {
                this.add();
                ++ret;
            }
            return ret;
        }

        private Json readString() {
            this.buf.setLength(0);
            while (this.c != '\"') {
                if (this.c == '\\') {
                    this.next();
                    if (this.c == 'u') {
                        this.add(this.unicode());
                        continue;
                    }
                    Character value = escapes.get(Character.valueOf(this.c));
                    if (value == null) continue;
                    this.add(value.charValue());
                    continue;
                }
                this.add();
            }
            this.next();
            return Json.factory().string(this.buf.toString());
        }

        private void add(char cc) {
            this.buf.append(cc);
            this.next();
        }

        private void add() {
            this.add(this.c);
        }

        private char unicode() {
            int value = 0;
            block5: for (int i = 0; i < 4; ++i) {
                switch (this.next()) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        value = (value << 4) + this.c - 48;
                        continue block5;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        value = (value << 4) + (this.c - 97) + 10;
                        continue block5;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': {
                        value = (value << 4) + (this.c - 65) + 10;
                    }
                }
            }
            return (char)value;
        }

        static {
            escapes.put(Character.valueOf('\"'), Character.valueOf('\"'));
            escapes.put(Character.valueOf('\\'), Character.valueOf('\\'));
            escapes.put(Character.valueOf('/'), Character.valueOf('/'));
            escapes.put(Character.valueOf('b'), Character.valueOf('\b'));
            escapes.put(Character.valueOf('f'), Character.valueOf('\f'));
            escapes.put(Character.valueOf('n'), Character.valueOf('\n'));
            escapes.put(Character.valueOf('r'), Character.valueOf('\r'));
            escapes.put(Character.valueOf('t'), Character.valueOf('\t'));
        }
    }

    public static class DefaultFactory
    implements Factory {
        @Override
        public Json nil() {
            return new NullJson();
        }

        @Override
        public Json bool(boolean x) {
            return new BooleanJson(x ? Boolean.TRUE : Boolean.FALSE, null);
        }

        @Override
        public Json string(String x) {
            return new StringJson(x, null);
        }

        @Override
        public Json number(Number x) {
            return new NumberJson(x, null);
        }

        @Override
        public Json array() {
            return new ArrayJson();
        }

        @Override
        public Json object() {
            return new ObjectJson();
        }

        @Override
        public Json make(Object anything) {
            if (anything == null) {
                return this.nil();
            }
            if (anything instanceof Json) {
                return (Json)anything;
            }
            if (anything instanceof String) {
                return Json.factory().string((String)anything);
            }
            if (anything instanceof Collection) {
                Json L = this.array();
                for (Object x : (Collection)anything) {
                    L.add(Json.factory().make(x));
                }
                return L;
            }
            if (anything instanceof Map) {
                Json O = this.object();
                for (Map.Entry x : ((Map)anything).entrySet()) {
                    O.set(x.getKey().toString(), Json.factory().make(x.getValue()));
                }
                return O;
            }
            if (anything instanceof Boolean) {
                return Json.factory().bool((Boolean)anything);
            }
            if (anything instanceof Number) {
                return Json.factory().number((Number)anything);
            }
            if (anything.getClass().isArray()) {
                Class<?> comp = anything.getClass().getComponentType();
                if (!comp.isPrimitive()) {
                    return Json.array((Object[])anything);
                }
                Json A = this.array();
                if (Boolean.TYPE == comp) {
                    for (boolean b : (boolean[])anything) {
                        A.add(b);
                    }
                } else if (Byte.TYPE == comp) {
                    for (byte b : (byte[])anything) {
                        A.add(b);
                    }
                } else if (Character.TYPE == comp) {
                    for (char b : (char[])anything) {
                        A.add(Character.valueOf(b));
                    }
                } else if (Short.TYPE == comp) {
                    for (short b : (short[])anything) {
                        A.add(b);
                    }
                } else if (Integer.TYPE == comp) {
                    for (int b : (int[])anything) {
                        A.add(b);
                    }
                } else if (Long.TYPE == comp) {
                    for (long b : (long[])anything) {
                        A.add(b);
                    }
                } else if (Float.TYPE == comp) {
                    for (float b : (float[])anything) {
                        A.add(Float.valueOf(b));
                    }
                } else if (Double.TYPE == comp) {
                    for (double b : (double[])anything) {
                        A.add(b);
                    }
                }
                return A;
            }
            throw new IllegalArgumentException("Don't know how to convert to Json : " + anything);
        }
    }

    static final class Escaper {
        private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        private static final Set<Character> JS_ESCAPE_CHARS = Set.of(Character.valueOf('\"'), Character.valueOf('\\'));
        private static final Set<Character> HTML_ESCAPE_CHARS = Set.of(Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('&'), Character.valueOf('='), Character.valueOf('\''));
        private final boolean escapeHtmlCharacters;

        Escaper(boolean escapeHtmlCharacters) {
            this.escapeHtmlCharacters = escapeHtmlCharacters;
        }

        private static boolean isControlCharacter(int codePoint) {
            return codePoint < 32 || codePoint == 8232 || codePoint == 8233 || codePoint >= 127 && codePoint <= 159;
        }

        private static void appendHexJavaScriptRepresentation(int codePoint, Appendable out) throws IOException {
            if (Character.isSupplementaryCodePoint(codePoint)) {
                char[] surrogates = Character.toChars(codePoint);
                Escaper.appendHexJavaScriptRepresentation(surrogates[0], out);
                Escaper.appendHexJavaScriptRepresentation(surrogates[1], out);
                return;
            }
            out.append("\\u").append(HEX_CHARS[codePoint >>> 12 & 0xF]).append(HEX_CHARS[codePoint >>> 8 & 0xF]).append(HEX_CHARS[codePoint >>> 4 & 0xF]).append(HEX_CHARS[codePoint & 0xF]);
        }

        public String escapeJsonString(CharSequence plainText) {
            StringBuilder escapedString = new StringBuilder(plainText.length() + 20);
            try {
                this.escapeJsonString(plainText, escapedString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return escapedString.toString();
        }

        private void escapeJsonString(CharSequence plainText, StringBuilder out) throws IOException {
            int charCount;
            int pos = 0;
            int len = plainText.length();
            block10: for (int i = 0; i < len; i += charCount) {
                int codePoint = Character.codePointAt(plainText, i);
                charCount = Character.charCount(codePoint);
                if (!Escaper.isControlCharacter(codePoint) && !this.mustEscapeCharInJsString(codePoint)) continue;
                out.append(plainText, pos, i);
                pos = i + charCount;
                switch (codePoint) {
                    case 8: {
                        out.append("\\b");
                        continue block10;
                    }
                    case 9: {
                        out.append("\\t");
                        continue block10;
                    }
                    case 10: {
                        out.append("\\n");
                        continue block10;
                    }
                    case 12: {
                        out.append("\\f");
                        continue block10;
                    }
                    case 13: {
                        out.append("\\r");
                        continue block10;
                    }
                    case 92: {
                        out.append("\\\\");
                        continue block10;
                    }
                    case 47: {
                        out.append("\\/");
                        continue block10;
                    }
                    case 34: {
                        out.append("\\\"");
                        continue block10;
                    }
                    default: {
                        Escaper.appendHexJavaScriptRepresentation(codePoint, out);
                    }
                }
            }
            out.append(plainText, pos, len);
        }

        private boolean mustEscapeCharInJsString(int codepoint) {
            if (!Character.isSupplementaryCodePoint(codepoint)) {
                char c = (char)codepoint;
                return JS_ESCAPE_CHARS.contains(Character.valueOf(c)) || this.escapeHtmlCharacters && HTML_ESCAPE_CHARS.contains(Character.valueOf(c));
            }
            return false;
        }
    }

    public static class MalformedJsonException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public MalformedJsonException(String msg) {
            super(msg);
        }
    }
}

