/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.mjson;

import com.mohistmc.mjson.Json;
import java.util.Collections;
import java.util.List;

public class NumberJson
extends Json {
    Number val;

    NumberJson() {
    }

    NumberJson(Json e) {
        super(e);
    }

    NumberJson(Number val, Json e) {
        super(e);
        this.val = val;
    }

    @Override
    public Json dup() {
        return new NumberJson(this.val, null);
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public Object getValue() {
        return this.val;
    }

    @Override
    public String asString() {
        return this.val.toString();
    }

    @Override
    public int asInteger() {
        return this.val.intValue();
    }

    @Override
    public float asFloat() {
        return this.val.floatValue();
    }

    @Override
    public double asDouble() {
        return this.val.doubleValue();
    }

    @Override
    public long asLong() {
        return this.val.longValue();
    }

    @Override
    public short asShort() {
        return this.val.shortValue();
    }

    @Override
    public byte asByte() {
        return this.val.byteValue();
    }

    @Override
    public List<Object> asList() {
        return Collections.singletonList(this.val);
    }

    public String toString() {
        return this.val.toString();
    }

    public int hashCode() {
        return this.val.hashCode();
    }

    public boolean equals(Object x) {
        return x instanceof NumberJson && this.val.doubleValue() == ((NumberJson)x).val.doubleValue();
    }
}

