/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc;

import com.mohistmc.action.ZipTree;
import com.mohistmc.action.v_1_20_1;
import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.feature.AutoDeleteMods;
import com.mohistmc.feature.CustomLibraries;
import com.mohistmc.feature.DefaultLibraries;
import com.mohistmc.feature.ExceptionHandler;
import com.mohistmc.i18n.i18n;
import com.mohistmc.tools.JarTool;
import com.mohistmc.tools.Logo;
import com.mohistmc.util.DataParser;
import com.mohistmc.util.EulaUtil;
import com.mohistmc.util.MohistModuleManager;
import com.mohistmc.util.UpdateUtils;
import cpw.mods.bootstraplauncher.BootstrapLauncher;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Stream;

public class MohistMCStart {
    public static final List<String> mainArgs = new ArrayList<String>();
    public static String MCVERSION;
    public static i18n i18n;
    public static JarTool jarTool;

    public static String getVersion() {
        return MohistMCStart.class.getPackage().getImplementationVersion() != null ? MohistMCStart.class.getPackage().getImplementationVersion() : "unknown";
    }

    public static void main(String[] args) throws Exception {
        mainArgs.addAll(List.of(args));
        jarTool = new JarTool(MohistMCStart.class);
        DataParser.parseVersions();
        DataParser.parseLaunchArgs();
        MohistConfigUtil.init();
        MohistConfigUtil.i18n();
        if (i18n.isCN()) {
            Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        }
        if (MohistConfigUtil.INSTALLATIONFINISHED() && MohistConfigUtil.aBoolean("mohist.show_logo", true)) {
            System.out.printf("%n%s%n%s - %s, Java(%s) %s PID: %s%n", Logo.asMohist(), i18n.as("mohist.launch.welcomemessage"), MohistMCStart.getVersion(), System.getProperty("java.class.version"), System.getProperty("java.version"), ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
            if (i18n.isCN()) {
                System.out.printf("\u5b98\u65b9\u4ea4\u6d41QQ\u7fa4: 158638%n", new Object[0]);
                System.out.printf("\u56fd\u5185\u5b98\u7f51\u5df2\u5f00\u653e: https://www.mohistmc.cn/%n", new Object[0]);
            }
        }
        if (System.getProperty("log4j.configurationFile") == null) {
            System.setProperty("log4j.configurationFile", "log4j2_mohist.xml");
        }
        if (MohistConfigUtil.INSTALLATIONFINISHED() && MohistConfigUtil.CHECK_UPDATE()) {
            new UpdateUtils().init();
        }
        ZipTree.init();
        if (MohistConfigUtil.INSTALLATIONFINISHED() && MohistConfigUtil.CHECK_LIBRARIES()) {
            DefaultLibraries.run();
        }
        if (MohistConfigUtil.INSTALLATIONFINISHED()) {
            v_1_20_1.run();
        }
        AutoDeleteMods.jar();
        CustomLibraries.loadCustomLibs();
        ArrayList<String> forgeArgs = new ArrayList<String>();
        for (String arg : DataParser.launchArgs.stream().filter(s -> s.startsWith("--launchTarget") || s.startsWith("--fml.forgeVersion") || s.startsWith("--fml.mcVersion") || s.startsWith("--fml.forgeGroup") || s.startsWith("--fml.mcpVersion")).toList()) {
            forgeArgs.add(arg.split(" ")[0]);
            forgeArgs.add(arg.split(" ")[1]);
        }
        new MohistModuleManager(DataParser.launchArgs);
        if (!EulaUtil.hasAcceptedEULA()) {
            System.out.println(i18n.as("eula"));
            while (!"true".equals(new Scanner(System.in).nextLine().trim())) {
                System.out.println(i18n.as("eula_notrue"));
            }
            EulaUtil.writeInfos();
        }
        String[] args_ = (String[])Stream.concat(forgeArgs.stream(), mainArgs.stream()).toArray(String[]::new);
        BootstrapLauncher.main((String[])args_);
    }
}

