/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.mohistmc.MohistMCStart;
import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.tools.ConnectionUtil;

public enum DownloadSource {
    MOHIST("https://maven.mohistmc.com/"),
    CHINA("http://s1.devicloud.cn:25119/"),
    GITHUB("https://mohistmc.github.io/maven/"),
    CUSTOM(null);

    public static final DownloadSource defaultSource;
    public String url;

    public static DownloadSource get() {
        String ds;
        String string = ds = System.getProperty("libraries.downloadsource") == null ? MohistConfigUtil.LIBRARIES_DOWNLOADSOURCE() : System.getProperty("libraries.downloadsource");
        if (ds.startsWith("http")) {
            DownloadSource.CUSTOM.url = ds;
            return CUSTOM;
        }
        for (DownloadSource me : DownloadSource.values()) {
            if (!me.name().equalsIgnoreCase(ds)) continue;
            DownloadSource urL = me;
            if (!ConnectionUtil.canAccess(me.url) && me.equals((Object)CHINA)) {
                urL = MOHIST;
            }
            if (!ConnectionUtil.canAccess(urL.url)) {
                return GITHUB;
            }
            return urL;
        }
        return defaultSource;
    }

    public static boolean isCN() {
        return MohistMCStart.i18n.isCN() && ConnectionUtil.measureLatency(CHINA.getUrl()) < ConnectionUtil.measureLatency(MOHIST.getUrl());
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "DownloadSource." + this.name() + "(url=" + this.getUrl() + ")";
    }

    private DownloadSource(String url) {
        this.url = url;
    }

    static {
        defaultSource = DownloadSource.isCN() ? CHINA : MOHIST;
    }
}

