/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.mohistmc.MohistMCStart;
import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.tools.ConnectionUtil;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public enum DownloadSource {
    MOHIST("https://maven.mohistmc.com/"),
    CHINA("http://s1.devicloud.cn:25119/"),
    GITHUB("https://mohistmc.github.io/maven/");

    public static final DownloadSource defaultSource;
    public final String url;

    public static DownloadSource get() {
        String ds = MohistConfigUtil.LIBRARIES_DOWNLOADSOURCE();
        for (DownloadSource me : DownloadSource.values()) {
            if (!me.name().equalsIgnoreCase(ds)) continue;
            if (DownloadSource.isDown(me.url)) {
                if (ds.equals("CHINA")) {
                    DownloadSource urL = MOHIST;
                    if (DownloadSource.isDown(urL.url)) {
                        return GITHUB;
                    }
                }
                return GITHUB;
            }
            return me;
        }
        return defaultSource;
    }

    public static boolean isCN() {
        return MohistMCStart.i18n.isCN() && ConnectionUtil.getUrlMillis(CHINA.getUrl()) < ConnectionUtil.getUrlMillis(MOHIST.getUrl());
    }

    public static boolean isDown(String s) {
        try {
            URL url = new URL(s);
            URLConnection rulConnection = url.openConnection();
            HttpURLConnection httpUrlConnection = (HttpURLConnection)rulConnection;
            httpUrlConnection.connect();
            return httpUrlConnection.getResponseCode() != 200;
        }
        catch (Exception e) {
            return true;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "DownloadSource." + this.name() + "(url=" + this.getUrl() + ")";
    }

    private DownloadSource(String url) {
        this.url = url;
    }

    static {
        defaultSource = DownloadSource.isCN() ? CHINA : MOHIST;
    }
}

