/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.i18n;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public class i18n {
    public Map<String, String> CURRENT_CACHE = new ConcurrentHashMap<String, String>();
    private PropertyResourceBundle rb;
    private PropertyResourceBundle defaultBundle;
    private final String properties = "message";
    private final Locale locale;

    public i18n(ClassLoader classLoader, Locale locale) {
        this.locale = i18n.locale(locale.toString());
        String lang = "_" + this.locale.getLanguage() + "_" + this.locale.getCountry();
        InputStream deFinputStream = classLoader.getResourceAsStream("lang/message.properties");
        InputStream inputStream = classLoader.getResourceAsStream("lang/message" + lang + ".properties");
        if (inputStream == null) {
            inputStream = deFinputStream;
        } else if (inputStream == null) {
            System.out.println("[i18N] Invalid language file");
            System.exit(0);
        }
        this.prb(deFinputStream, inputStream);
    }

    public i18n(ClassLoader classLoader, String langByString) {
        this(classLoader, i18n.locale(langByString));
    }

    public i18n(Class<?> classz, Locale locale) {
        this.locale = i18n.locale(locale.toString());
        String lang = "_" + this.locale.getLanguage() + "_" + this.locale.getCountry();
        InputStream deFinputStream = classz.getResourceAsStream("/lang/message.properties");
        InputStream inputStream = classz.getResourceAsStream("/lang/message" + lang + ".properties");
        if (inputStream == null) {
            inputStream = deFinputStream;
        } else if (inputStream == null) {
            System.out.println("[i18N] Invalid language file");
            System.exit(0);
        }
        this.prb(deFinputStream, inputStream);
    }

    public i18n(Class<?> classz, String langByString) {
        this(classz, i18n.locale(langByString));
    }

    private static Locale locale(String locale) {
        Locale defaultLocale = Locale.getDefault();
        if (locale.contains("_") && locale.split("_").length == 2) {
            String l = locale.split("_")[0];
            String c = locale.split("_")[1];
            defaultLocale = new Locale(l, c);
        }
        if (defaultLocale.getLanguage().isEmpty() || defaultLocale.getCountry().isEmpty()) {
            defaultLocale = new Locale("xx", "XX");
        }
        return defaultLocale;
    }

    private void prb(InputStream deFinputStream, InputStream in) {
        this.defaultBundle = new PropertyResourceBundle(new InputStreamReader(deFinputStream, StandardCharsets.UTF_8));
        this.rb = new PropertyResourceBundle(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    @Deprecated
    public String get(String key) {
        String string = this.rb.containsKey(key) ? this.rb.getString(key) : (this.defaultBundle.containsKey(key) ? this.defaultBundle.getString(key) : key);
        if (this.CURRENT_CACHE.containsKey(key)) {
            return this.CURRENT_CACHE.get(key);
        }
        this.CURRENT_CACHE.put(key, string);
        return string;
    }

    public String as(String key) {
        return this.get(key);
    }

    @Deprecated
    public String get(String key, Object ... f) {
        return new MessageFormat(this.get(key)).format(f);
    }

    public String as(String key, Object ... f) {
        return this.get(key).formatted(f);
    }

    public boolean isCN() {
        return this.is("CN");
    }

    public boolean is(String country) {
        return Locale.getDefault().getCountry().equals(country) || country.equals(this.locale.getCountry());
    }
}

