/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.command;

import com.mohistmc.api.PlayerAPI;
import com.mohistmc.api.ServerAPI;
import com.mohistmc.util.i18n.i18n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MohistCommand
extends Command {
    private List<String> params = Arrays.asList("mods", "playermods", "lang");

    public MohistCommand(String name) {
        super(name);
        this.description = "Mohist related commands";
        this.usageMessage = "/mohist [mods|playermods|lang]";
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1 && sender.isOp()) {
            for (String param : this.params) {
                if (!param.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(param);
            }
        }
        return list;
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!sender.isOp()) {
            sender.sendMessage(i18n.get("command.nopermission"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        if ("mods".equals(args[0].toLowerCase(Locale.ENGLISH))) {
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "" + ServerAPI.getModSize() + " " + ServerAPI.getModList());
        } else if ("playermods".equals(args[0].toLowerCase(Locale.ENGLISH))) {
            if (args.length == 1) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
                return false;
            }
            Player player = Bukkit.getPlayer(args[1]);
            if (player != null) {
                sender.sendMessage((Object)((Object)ChatColor.GREEN) + "" + PlayerAPI.getModSize(player) + " " + PlayerAPI.getModlist(player));
            } else {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "The player [" + args[1] + "] is not online.");
            }
        } else if ("lang".equals(args[0].toLowerCase(Locale.ENGLISH))) {
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + ServerAPI.getLanguage());
        } else {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        return true;
    }
}

