/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.libraries;

import com.mohistmc.configuration.MohistConfigUtil;
import com.mohistmc.network.UpdateUtils;
import com.mohistmc.util.JarLoader;
import com.mohistmc.util.JarTool;
import com.mohistmc.util.MD5Util;
import com.mohistmc.util.i18n.i18n;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class DefaultLibraries {
    private static int retry = 0;
    public static HashMap<String, String> fail = new HashMap();

    public static void run() throws Exception {
        System.out.println(i18n.get("libraries.checking.start"));
        String url = "https://maven.mohistmc.com/";
        if (i18n.isLang("CN")) {
            url = "https://mohist-community.gitee.io/mohistdown/";
        }
        LinkedHashMap<File, String> libs = DefaultLibraries.getDefaultLibs();
        for (File file : DefaultLibraries.getDefaultLibs().keySet()) {
            if (file.exists() && MD5Util.md5CheckSum(file, libs.get(file)) || MohistConfigUtil.getString(MohistConfigUtil.mohistyml, "libraries_black_list:", "xxxxx").contains(file.getName())) continue;
            file.getParentFile().mkdirs();
            String u = url + "libraries/" + file.getAbsolutePath().replaceAll("\\\\", "/").split("/libraries/")[1];
            System.out.println(i18n.get("libraries.global.percentage") + String.valueOf((float)UpdateUtils.getSizeOfDirectory(new File(JarTool.getJarDir() + "/libraries")) / 35.0f * 100.0f).substring(0, 2).replace(".", "") + "%");
            try {
                UpdateUtils.downloadFile(u, file);
                fail.remove(u);
            }
            catch (Exception e) {
                System.out.println(i18n.get("file.download.nook", u));
                file.delete();
                fail.put(u, file.getAbsolutePath());
            }
        }
        if (retry < 3 && !fail.isEmpty()) {
            System.out.println(i18n.get("update.retry", ++retry));
            DefaultLibraries.run();
        } else {
            System.out.println(i18n.get("libraries.checking.end"));
            if (!fail.isEmpty()) {
                System.out.println(i18n.get("libraries.cant.start.server"));
                for (String string : fail.keySet()) {
                    System.out.println("Link : " + string + "\nPath : " + fail.get(string) + "\n");
                }
                System.exit(0);
            }
        }
    }

    public static LinkedHashMap<File, String> getDefaultLibs() throws Exception {
        String str;
        LinkedHashMap<File, String> temp = new LinkedHashMap<File, String>();
        BufferedReader b2 = new BufferedReader(new InputStreamReader(DefaultLibraries.class.getClassLoader().getResourceAsStream("mohist_libraries.txt")));
        while ((str = b2.readLine()) != null) {
            String[] s = str.split("\\|");
            temp.put(new File(JarTool.getJarDir() + "/" + s[0]), s[1]);
        }
        b2.close();
        return temp;
    }

    public static void loadDefaultLibs() throws Exception {
        for (File lib : DefaultLibraries.getDefaultLibs().keySet()) {
            if (!lib.exists() || MohistConfigUtil.getString(MohistConfigUtil.mohistyml, "libraries_black_list:", "xxxxx").contains(lib.getName())) continue;
            JarLoader.loadjar(lib.getAbsolutePath());
        }
    }
}

