/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.RemapperProcessor;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;
import net.md_5.specialsource.transformer.MappingTransformer;
import net.md_5.specialsource.transformer.MavenShade;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.CauldronUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import thermos.ThermosRemapper;

public class PluginClassLoader
extends URLClassLoader {
    private final JavaPluginLoader loader;
    private final ConcurrentMap<String, Class<?>> classes = new ConcurrentHashMap();
    private final PluginDescriptionFile description;
    private final File dataFolder;
    private final File file;
    JavaPlugin plugin;
    private JavaPlugin pluginInit;
    private IllegalStateException pluginState;
    private JarRemapper remapper;
    private RemapperProcessor remapperProcessor;
    private boolean debug;
    private int remapFlags = -1;
    private static ConcurrentMap<Integer, JarMapping> jarMappings = new ConcurrentHashMap<Integer, JarMapping>();
    private static final int F_GLOBAL_INHERIT = 2;
    private static final int F_REMAP_OBCPRE = 4;
    private static final int F_REMAP_NMS152 = 8;
    private static final int F_REMAP_NMS164 = 16;
    private static final int F_REMAP_NMS172 = 32;
    private static final int F_REMAP_NMS179 = 64;
    private static final int F_REMAP_NMS1710 = 128;
    private static final int F_REMAP_OBC152 = 256;
    private static final int F_REMAP_OBC164 = 512;
    private static final int F_REMAP_OBC172 = 1024;
    private static final int F_REMAP_OBC179 = 2048;
    private static final int F_REMAP_OBC1710 = 4096;
    private static final int F_REMAP_NMSPRE_MASK = -65536;
    private static final String org_bukkit_craftbukkit = new String(new char[]{'o', 'r', 'g', '/', 'b', 'u', 'k', 'k', 'i', 't', '/', 'c', 'r', 'a', 'f', 't', 'b', 'u', 'k', 'k', 'i', 't'});

    PluginClassLoader(JavaPluginLoader loader, ClassLoader parent, PluginDescriptionFile description, File dataFolder, File file) throws InvalidPluginException, MalformedURLException {
        super(new URL[]{file.toURI().toURL()}, parent);
        Validate.notNull((Object)loader, (String)"Loader cannot be null");
        this.loader = loader;
        this.description = description;
        this.dataFolder = dataFolder;
        this.file = file;
        String pluginName = this.description.getName();
        MinecraftServer.I();
        boolean useCustomClassLoader = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.custom-class-loader", true);
        MinecraftServer.I();
        this.debug = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.debug", false);
        MinecraftServer.I();
        boolean remapNMS1710 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_7_R4", true);
        MinecraftServer.I();
        boolean remapNMS179 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_7_R3", true);
        MinecraftServer.I();
        boolean remapNMS172 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_7_R1", true);
        MinecraftServer.I();
        boolean remapNMS164 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_6_R3", true);
        MinecraftServer.I();
        boolean remapNMS152 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_5_R3", true);
        MinecraftServer.I();
        String remapNMSPre = MinecraftServer.cauldronConfig.getString("plugin-settings.default.remap-nms-pre", "false");
        MinecraftServer.I();
        boolean remapOBC1710 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_7_R4", true);
        MinecraftServer.I();
        boolean remapOBC179 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_7_R3", true);
        MinecraftServer.I();
        boolean remapOBC172 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_7_R1", true);
        MinecraftServer.I();
        boolean remapOBC164 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_6_R3", true);
        MinecraftServer.I();
        boolean remapOBC152 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_5_R3", true);
        MinecraftServer.I();
        boolean remapOBCPre = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-pre", false);
        MinecraftServer.I();
        boolean globalInherit = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.global-inheritance", true);
        MinecraftServer.I();
        boolean pluginInherit = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.plugin-inheritance", true);
        MinecraftServer.I();
        boolean reflectFields = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-reflect-field", true);
        MinecraftServer.I();
        boolean reflectClass = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-reflect-class", true);
        MinecraftServer.I();
        boolean allowFuture = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-allow-future", false);
        MinecraftServer.I();
        useCustomClassLoader = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".custom-class-loader", useCustomClassLoader, false);
        MinecraftServer.I();
        this.debug = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".debug", this.debug, false);
        MinecraftServer.I();
        remapNMS1710 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_7_R4", remapNMS1710, false);
        MinecraftServer.I();
        remapNMS179 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_7_R3", remapNMS179, false);
        MinecraftServer.I();
        remapNMS172 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_7_R1", remapNMS172, false);
        MinecraftServer.I();
        remapNMS164 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_6_R3", remapNMS164, false);
        MinecraftServer.I();
        remapNMS152 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_5_R3", remapNMS152, false);
        MinecraftServer.I();
        remapNMSPre = MinecraftServer.cauldronConfig.getString("plugin-settings." + pluginName + ".remap-nms-pre", remapNMSPre, false);
        MinecraftServer.I();
        remapOBC1710 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_7_R4", remapOBC1710, false);
        MinecraftServer.I();
        remapOBC179 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_7_R3", remapOBC179, false);
        MinecraftServer.I();
        remapOBC172 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_7_R1", remapOBC172, false);
        MinecraftServer.I();
        remapOBC164 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_6_R3", remapOBC164, false);
        MinecraftServer.I();
        remapOBC152 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_5_R3", remapOBC152, false);
        MinecraftServer.I();
        remapOBCPre = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-pre", remapOBCPre, false);
        MinecraftServer.I();
        globalInherit = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".global-inheritance", globalInherit, false);
        MinecraftServer.I();
        pluginInherit = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".plugin-inheritance", pluginInherit, false);
        MinecraftServer.I();
        reflectFields = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-reflect-field", reflectFields, false);
        MinecraftServer.I();
        reflectClass = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-reflect-class", reflectClass, false);
        MinecraftServer.I();
        allowFuture = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-allow-future", allowFuture, false);
        if (this.debug) {
            System.out.println("PluginClassLoader debugging enabled for " + pluginName);
        }
        if (!useCustomClassLoader) {
            this.remapper = null;
            return;
        }
        int flags = 0;
        if (remapNMS1710) {
            flags |= 0x80;
        }
        if (remapNMS179) {
            flags |= 0x40;
        }
        if (remapNMS172) {
            flags |= 0x20;
        }
        if (remapNMS164) {
            flags |= 0x10;
        }
        if (remapNMS152) {
            flags |= 8;
        }
        if (!remapNMSPre.equals("false")) {
            if (remapNMSPre.equals("1.7.10")) {
                flags |= 0x17100000;
            } else if (remapNMSPre.equals("1.7.9")) {
                flags |= 0x1790000;
            } else if (remapNMSPre.equals("1.7.2")) {
                flags |= 0x1720000;
            } else if (remapNMSPre.equals("1.6.4")) {
                flags |= 0x1640000;
            } else if (remapNMSPre.equals("1.5.2")) {
                flags |= 0x1520000;
            } else {
                System.out.println("Unsupported nms-remap-pre version '" + remapNMSPre + "', disabling");
            }
        }
        if (remapOBC1710) {
            flags |= 0x1000;
        }
        if (remapOBC179) {
            flags |= 0x800;
        }
        if (remapOBC172) {
            flags |= 0x400;
        }
        if (remapOBC164) {
            flags |= 0x200;
        }
        if (remapOBC152) {
            flags |= 0x100;
        }
        if (remapOBCPre) {
            flags |= 4;
        }
        if (globalInherit) {
            flags |= 2;
        }
        this.remapFlags = flags;
        JarMapping jarMapping = this.getJarMapping(flags);
        if ((flags & 2) != 0) {
            if (this.debug) {
                System.out.println("Enabling global inheritance remapping");
            }
            jarMapping.setInheritanceMap(loader.getGlobalInheritanceMap());
            jarMapping.setFallbackInheritanceProvider((InheritanceProvider)new ClassLoaderProvider((ClassLoader)this));
        }
        this.remapper = new ThermosRemapper(jarMapping);
        if (pluginInherit || reflectFields || reflectClass) {
            this.remapperProcessor = new RemapperProcessor(pluginInherit ? loader.getGlobalInheritanceMap() : null, (JarMapping)(reflectFields || reflectClass ? jarMapping : null));
            this.remapperProcessor.setRemapReflectField(reflectFields);
            this.remapperProcessor.setRemapReflectClass(reflectClass);
            this.remapperProcessor.debug = this.debug;
        } else {
            this.remapperProcessor = null;
        }
        try {
            Class<JavaPlugin> pluginClass;
            Class<?> jarClass;
            try {
                jarClass = Class.forName(description.getMain(), true, this);
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidPluginException("Cannot find main class `" + description.getMain() + "'", ex);
            }
            try {
                pluginClass = jarClass.asSubclass(JavaPlugin.class);
            }
            catch (ClassCastException ex) {
                throw new InvalidPluginException("main class `" + description.getMain() + "' does not extend JavaPlugin", ex);
            }
            this.plugin = pluginClass.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPluginException("No public constructor", ex);
        }
        catch (InstantiationException ex) {
            throw new InvalidPluginException("Abnormal plugin type", ex);
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    public static String getNativeVersion() {
        if (CauldronUtils.deobfuscatedEnvironment()) {
            return "v1_7_R4";
        }
        String packageName = CraftServer.class.getPackage().getName();
        return packageName.substring(packageName.lastIndexOf(46) + 1);
    }

    private void loadNmsMappings(JarMapping jarMapping, String obfVersion) throws IOException {
        HashMap<String, String> relocations = new HashMap<String, String>();
        relocations.put("net.minecraft.server", "net.minecraft.server." + obfVersion);
        if (CauldronUtils.deobfuscatedEnvironment() && obfVersion.equals("v1_7_R4")) {
            jarMapping.loadMappings(new BufferedReader(new InputStreamReader(this.loader.getClass().getClassLoader().getResourceAsStream("mappings/" + obfVersion + "/cb2pkgmcp.srg"))), (MappingTransformer)new MavenShade(relocations), null, false);
            jarMapping.loadMappings(new BufferedReader(new InputStreamReader(this.loader.getClass().getClassLoader().getResourceAsStream("mappings/" + obfVersion + "/obf2pkgmcp.srg"))), null, null, false);
            jarMapping.methods.put("net/minecraft/server/" + obfVersion + "/PlayerConnection/getPlayer ()Lorg/bukkit/craftbukkit/entity/CraftPlayer;", "getPlayerB");
        } else {
            jarMapping.loadMappings(new BufferedReader(new InputStreamReader(this.loader.getClass().getClassLoader().getResourceAsStream("mappings/" + obfVersion + "/cb2numpkg.srg"))), (MappingTransformer)new MavenShade(relocations), null, false);
            if (obfVersion.equals("v1_7_R4")) {
                jarMapping.loadMappings(new BufferedReader(new InputStreamReader(this.loader.getClass().getClassLoader().getResourceAsStream("mappings/" + obfVersion + "/obf2numpkg.srg"))), null, null, false);
            }
            jarMapping.methods.put("net/minecraft/server/" + obfVersion + "/PlayerConnection/getPlayer ()Lorg/bukkit/craftbukkit/" + PluginClassLoader.getNativeVersion() + "/entity/CraftPlayer;", "getPlayerB");
        }
    }

    private JarMapping getJarMapping(int flags) {
        JarMapping jarMapping = (JarMapping)jarMappings.get(flags);
        if (jarMapping != null) {
            if (this.debug) {
                System.out.println("Mapping reused for " + Integer.toHexString(flags));
            }
            return jarMapping;
        }
        jarMapping = new JarMapping();
        try {
            block43: {
                String[] vn;
                if (this.description.getName().equals("PermissionsEx")) {
                    vn = this.description.getVersion().split(".");
                    if (vn.length >= 2) {
                        try {
                            if (Integer.parseInt(vn[1]) >= 23) {
                                jarMapping.packages.put("com/google/common", "guava17/com/google/common");
                                break block43;
                            }
                            jarMapping.packages.put("com/google/common", "guava10/com/google/common");
                        }
                        catch (Exception e) {
                            jarMapping.packages.put("com/google/common", "guava10/com/google/common");
                        }
                    } else {
                        jarMapping.packages.put("com/google/common", "guava10/com/google/common");
                    }
                } else if (this.description.getName().equals("BuycraftX")) {
                    vn = this.description.getVersion().split(".");
                    if (vn.length >= 2) {
                        try {
                            if (Integer.parseInt(vn[1]) >= 10) {
                                jarMapping.packages.put("com/google/common", "guava17/com/google/common");
                                break block43;
                            }
                            jarMapping.packages.put("com/google/common", "guava10/com/google/common");
                        }
                        catch (Exception e) {
                            jarMapping.packages.put("com/google/common", "guava10/com/google/common");
                        }
                    } else {
                        jarMapping.packages.put("com/google/common", "guava10/com/google/common");
                    }
                } else {
                    jarMapping.packages.put("com/google/common", "guava10/com/google/common");
                }
            }
            jarMapping.packages.put(org_bukkit_craftbukkit + "/libs/com/google/gson", "com/google/gson");
            jarMapping.packages.put("net/minecraft/util/io", "io");
            jarMapping.packages.put("net/minecraft/util/com", "com");
            jarMapping.packages.put("net/minecraft/util/gnu", "gnu");
            jarMapping.packages.put("net/minecraft/util/org", "org");
            if ((flags & 0x80) != 0) {
                this.loadNmsMappings(jarMapping, "v1_7_R4");
            }
            if ((flags & 0x40) != 0) {
                this.loadNmsMappings(jarMapping, "v1_7_R3");
            }
            if ((flags & 0x20) != 0) {
                this.loadNmsMappings(jarMapping, "v1_7_R1");
            }
            if ((flags & 0x10) != 0) {
                this.loadNmsMappings(jarMapping, "v1_6_R3");
            }
            if ((flags & 8) != 0) {
                this.loadNmsMappings(jarMapping, "v1_5_R3");
            }
            if ((flags & 0x1000) != 0) {
                if (CauldronUtils.deobfuscatedEnvironment()) {
                    jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_7_R4", org_bukkit_craftbukkit);
                } else {
                    jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_7_R4", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
                }
            }
            if ((flags & 0x800) != 0) {
                if (CauldronUtils.deobfuscatedEnvironment()) {
                    jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_7_R3", org_bukkit_craftbukkit);
                } else {
                    jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_7_R3", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
                }
            }
            if ((flags & 0x400) != 0) {
                if (CauldronUtils.deobfuscatedEnvironment()) {
                    jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_7_R1", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
                } else {
                    jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_7_R1", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
                }
            }
            if ((flags & 0x200) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_6_R3", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0x100) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_5_R3", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 4) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/libs/org/objectweb/asm", "org/objectweb/asm");
                jarMapping.packages.put(org_bukkit_craftbukkit, org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0xFFFF0000) != 0) {
                String obfVersion;
                switch (flags & 0xFFFF0000) {
                    case 0x17100000: {
                        obfVersion = "v1_7_R4";
                        break;
                    }
                    case 24707072: {
                        obfVersion = "v1_7_R3";
                        break;
                    }
                    case 24248320: {
                        obfVersion = "v1_7_R1";
                        break;
                    }
                    case 23330816: {
                        obfVersion = "v1_6_R3";
                        break;
                    }
                    case 0x1510000: {
                        obfVersion = "v1_5_R2";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid unversioned mapping flags: " + Integer.toHexString(flags & 0xFFFF0000) + " in " + Integer.toHexString(flags));
                    }
                }
                jarMapping.loadMappings(new BufferedReader(new InputStreamReader(this.loader.getClass().getClassLoader().getResourceAsStream("mappings/" + obfVersion + "/cb2numpkg.srg"))), null, null, false);
            }
            System.out.println("Mapping loaded " + jarMapping.packages.size() + " packages, " + jarMapping.classes.size() + " classes, " + jarMapping.fields.size() + " fields, " + jarMapping.methods.size() + " methods, flags " + Integer.toHexString(flags));
            JarMapping currentJarMapping = jarMappings.putIfAbsent(flags, jarMapping);
            return currentJarMapping == null ? jarMapping : currentJarMapping;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?> findClass(String name, boolean checkGlobal) throws ClassNotFoundException {
        if (name.startsWith("net.minecraft.")) {
            JarMapping jarMapping = this.getJarMapping(this.remapFlags);
            String remappedClass = (String)jarMapping.classes.get(name.replaceAll("\\.", "\\/"));
            Class<?> clazz = ((LaunchClassLoader)MinecraftServer.I().getClass().getClassLoader()).findClass(remappedClass);
            return clazz;
        }
        if (name.startsWith("org.bukkit.")) {
            if (this.debug) {
                System.out.println("Unexpected plugin findClass on OBC/NMS: name=" + name + ", checkGlobal=" + checkGlobal + "; returning not found");
            }
            throw new ClassNotFoundException(name);
        }
        String string = name.intern();
        synchronized (string) {
            Class<?> result = (Class<?>)this.classes.get(name);
            if (result == null) {
                Class<?> old;
                if (checkGlobal) {
                    result = this.loader.getClassByName(name);
                }
                if (result == null && (result = this.remapper == null ? super.findClass(name) : this.remappedFindClass(name)) != null) {
                    this.loader.setClass(name, result);
                }
                if (result != null && (old = this.classes.putIfAbsent(name, result)) != null && old != result) {
                    System.err.println("Defined class " + name + " twice as different classes, " + result + " and " + old);
                    result = old;
                }
            }
            return result;
        }
    }

    private Class<?> remappedFindClass(String name) throws ClassNotFoundException {
        Class<?> result;
        block8: {
            result = null;
            try {
                JarURLConnection jarURLConnection;
                URL jarURL;
                CodeSource codeSource;
                InputStream stream;
                String path = name.replace('.', '/').concat(".class");
                URL url = this.findResource(path);
                if (url == null || (stream = url.openStream()) == null) break block8;
                byte[] bytecode = null;
                if (this.remapperProcessor != null && (bytecode = this.remapperProcessor.process(stream)) == null) {
                    stream = url.openStream();
                }
                byte[] remappedBytecode = this.remapper.remapClassFile(bytecode, (ClassRepo)RuntimeRepo.getInstance());
                if (this.debug) {
                    File file = new File("remapped-plugin-classes/" + name + ".class");
                    file.getParentFile().mkdirs();
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(remappedBytecode);
                        fileOutputStream.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if ((result = this.defineClass(name, remappedBytecode, 0, remappedBytecode.length, codeSource = new CodeSource(jarURL = (jarURLConnection = (JarURLConnection)url.openConnection()).getJarFileURL(), new CodeSigner[0]))) != null) {
                    this.resolveClass(result);
                }
            }
            catch (Throwable t) {
                if (this.debug) {
                    System.out.println("remappedFindClass(" + name + ") exception: " + t);
                    t.printStackTrace();
                }
                throw new ClassNotFoundException("Failed to remap class " + name, t);
            }
        }
        return result;
    }

    Set<String> getClasses() {
        return this.classes.keySet();
    }

    synchronized void initialize(JavaPlugin javaPlugin) {
        Validate.notNull((Object)javaPlugin, (String)"Initializing plugin cannot be null");
        Validate.isTrue((javaPlugin.getClass().getClassLoader() == this ? 1 : 0) != 0, (String)"Cannot initialize plugin outside of this class loader");
        if (this.plugin != null || this.pluginInit != null) {
            throw new IllegalArgumentException("Plugin already initialized!", this.pluginState);
        }
        this.pluginState = new IllegalStateException("Initial initialization");
        this.pluginInit = javaPlugin;
        javaPlugin.init(this.loader, this.loader.server, this.description, this.dataFolder, this.file, this);
    }
}

